/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.morilib.awk.AwkCompilationException;
import net.morilib.awk.AwkException;
import net.morilib.awk.AwkExitException;
import net.morilib.awk.AwkNextException;
import net.morilib.awk.builtin.AwkBuiltInLoader;
import net.morilib.awk.code.AwkProgram;
import net.morilib.awk.encoding.EncodingDetector;
import net.morilib.awk.encoding.EncodingDetectorFactory;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.misc.FilesReader;
import net.morilib.awk.misc.RecordInputStream;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.namespace.AwkRootNamespace;
import net.morilib.awk.parser.AwkLexer;
import net.morilib.awk.parser.AwkParser;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;
import net.morilib.c.pre.CPreprocessorReader;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFile;
import net.morilib.sh.ShFileGetter;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Awk
implements ShProcess {
    private static final Awk _INS = new Awk();
    private static final String FILENOTFOUND = "fatal: script not found: ";
    public static final String VERSION = "0.2.3";

    private Awk() {
    }

    public static Awk getInstance() {
        return _INS;
    }

    private static void initvar(AwkNamespace r, Map<Object, Object> vars) {
        if (vars != null) {
            for (Map.Entry<Object, Object> o : vars.entrySet()) {
                String s = o.getValue().toString();
                s = AwkLexer.escape(s);
                r.assign(o.getKey().toString(), AwkString.valueOf(s));
            }
        }
    }

    public static AwkNamespace newNamespace(String filename, String ... args) {
        AwkRootNamespace r = new AwkRootNamespace();
        AwkBuiltInLoader.load(r);
        r.assign("FILENAME", AwkString.valueOf(filename));
        r.assign("ARGC", AwkInteger.valueOf(args.length));
        r.assign("ARGV", new AwkArray(0, args));
        AwkArray a = new AwkArray();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            ((AwkValue)a).putArray(e.getKey(), AwkString.valueOf(e.getValue()));
        }
        r.assign("ENVIRON", a);
        a = new AwkArray();
        for (Object o : System.getProperties().keySet()) {
            String s = o.toString();
            ((AwkValue)a).putArray(s, AwkString.valueOf(System.getProperty(s)));
        }
        r.assign("PROPERTIES", a);
        return r;
    }

    public AwkProgram compile(AwkNamespace namespace, Reader source) throws IOException {
        AwkLexer l = new AwkLexer(source);
        AwkProgram p = AwkParser.parse(namespace, l);
        return p;
    }

    public AwkValue execute(AwkNamespace namespace, AwkFiles f, AwkProgram program, String filename, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, String ... args) throws IOException {
        RecordInputStream rd = new RecordInputStream(stdin, inputEncoding, namespace);
        try {
            if (!program.isExecuteOnce()) {
                String s;
                while ((s = rd.readRecord()) != null) {
                    try {
                        program.execute(namespace, f, s);
                    }
                    catch (AwkNextException awkNextException) {
                        stdout.flush();
                        stderr.flush();
                        continue;
                    }
                    catch (AwkExitException e) {
                        try {
                            program.executeEnd(namespace, f);
                            AwkValue awkValue = e.getValue();
                            if (f != null) {
                                f.closeAll();
                            }
                            return awkValue;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            stdout.flush();
                            stderr.flush();
                        }
                    }
                    stdout.flush();
                    stderr.flush();
                }
            }
            AwkInteger awkInteger = AwkInteger.ZERO;
            return awkInteger;
        }
        finally {
            if (f != null) {
                f.closeAll();
            }
        }
    }

    public AwkValue execute(ShFileSystem filesystem, Reader source, String filename, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        AwkNamespace r = Awk.newNamespace(filename, args);
        AwkFiles f = new AwkFiles(filesystem, stdin, stdout, stderr);
        Awk.initvar(r, vars);
        AwkProgram p = this.compile(r, source);
        p.executeBegin(r, f);
        if (p.isExecuteOnce()) {
            return AwkInteger.ZERO;
        }
        AwkValue rt = this.execute(r, f, p, filename, stdin, stdout, stderr, inputEncoding, args);
        p.executeEnd(r, f);
        stdout.flush();
        stderr.flush();
        return rt;
    }

    public AwkValue execute(ShFileSystem filesystem, Reader source, ShFile inputFile, ShFile outputFile, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        Writer stdout = null;
        InputStream stdin = null;
        try {
            stdin = inputFile.getInputStream();
            stdout = outputEncoding != null ? new OutputStreamWriter((OutputStream)outputFile.getPrintStream(false), outputEncoding) : new OutputStreamWriter(outputFile.getPrintStream(false));
            AwkValue awkValue = this.execute(filesystem, source, inputFile.toString(), stdin, stdout, stderr, inputEncoding, vars, args);
            return awkValue;
        }
        finally {
            if (stdin != null) {
                stdin.close();
            }
            if (stdout != null) {
                stdout.flush();
                stdout.close();
            }
        }
    }

    public AwkValue execute(ShFileSystem filesystem, String source, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute(filesystem, (Reader)srd, "<no name>", stdin, stdout, stderr, inputEncoding, vars, args);
    }

    public AwkValue execute(ShFileSystem filesystem, String source, InputStream stdin, OutputStream stdout, OutputStream stderr, Charset inputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute(filesystem, (Reader)srd, "<no name>", stdin, (Writer)new OutputStreamWriter(stdout), (Writer)new OutputStreamWriter(stderr), inputEncoding, vars, args);
    }

    public AwkValue execute(ShFileSystem filesystem, String source, InputStream stdin, Writer stdout, Writer stderr, Charset inputEncoding) throws IOException {
        return this.execute(filesystem, source, stdin, stdout, stderr, inputEncoding, new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(ShFileSystem filesystem, String source, InputStream stdin, OutputStream stdout, OutputStream stderr, Charset inputEncoding) throws IOException {
        return this.execute(filesystem, source, stdin, stdout, stderr, inputEncoding, new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(ShFileSystem filesystem, String source, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        return this.execute(filesystem, source, stdin, stdout, stderr, Charset.defaultCharset(), new HashMap<Object, Object>(), new String[0]);
    }

    public AwkValue execute(ShFileSystem filesystem, String source, ShFile inputFile, ShFile outputFile, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.execute(filesystem, (Reader)srd, inputFile, outputFile, stderr, inputEncoding, outputEncoding, vars, args);
    }

    public AwkValue overwrite(ShFileSystem filesystem, Reader source, ShFile file, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        AwkValue v;
        File tf = File.createTempFile("awkium", ".tmp");
        BufferedOutputStream ous = null;
        BufferedInputStream ins = null;
        byte[] b = new byte[4096];
        Writer stdout = null;
        InputStream stdin = null;
        try {
            stdin = file.getInputStream();
            stdout = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(tf), outputEncoding) : new OutputStreamWriter(new FileOutputStream(tf));
            AwkNamespace ns = Awk.newNamespace("<stdin>", new String[0]);
            AwkProgram p = this.compile(ns, source);
            AwkFiles fs = new AwkFiles(filesystem, stdin, stdout, stderr);
            Awk.initvar(ns, vars);
            p.executeBegin(ns, fs);
            stdout.flush();
            stderr.flush();
            if (p.isExecuteOnce()) {
                AwkInteger awkInteger = AwkInteger.ZERO;
                return awkInteger;
            }
            v = this.execute(ns, fs, p, file.toString(), stdin, stdout, stderr, inputEncoding, args);
            p.executeEnd(ns, fs);
            stdout.flush();
            stderr.flush();
        }
        finally {
            if (stdin != null) {
                stdin.close();
            }
            if (stdout != null) {
                stdout.flush();
                stdout.close();
            }
        }
        try {
            int l;
            ins = new BufferedInputStream(new FileInputStream(tf));
            ous = new BufferedOutputStream(file.getPrintStream(false));
            while ((l = ins.read(b)) >= 0) {
                ous.write(b, 0, l);
            }
            AwkValue awkValue = v;
            return awkValue;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (ous != null) {
                ous.flush();
                ous.close();
            }
            tf.delete();
        }
    }

    public AwkValue overwrite(ShFileSystem filesystem, String source, ShFile file, Writer stderr, Charset inputEncoding, Charset outputEncoding, Map<Object, Object> vars, String ... args) throws IOException {
        StringReader srd = new StringReader(source);
        return this.overwrite(filesystem, srd, file, stderr, inputEncoding, outputEncoding, vars, args);
    }

    void setawkpath() {
    }

    ShFile searchAwkPath(ShFileGetter g, ShFileSystem fs, String s) {
        if (g.get(fs, s).isFile()) {
            return g.get(fs, s);
        }
        return null;
    }

    public void usage() {
        System.err.print("awkium Ver. ");
        System.err.println(VERSION);
        System.err.println("usage:");
        System.err.println("awk [option] script [files ...]");
        System.err.println("awk [option] [files ...]");
        System.err.println("awk");
        System.err.println("awk --repl");
        System.err.println("");
        System.err.println("option:");
        System.err.println("-F file-separator");
        System.err.println("-f script-file");
        System.err.println("-v variable=value");
        System.err.println("--source script");
        System.err.println("--version");
        System.err.println("--help (--usage)");
        System.err.println("--with-cpp");
    }

    /*
     * Loose catch block
     */
    public void repl(ShFileSystem filesystem) {
        AwkNamespace r = Awk.newNamespace("<stdin>", new String[0]);
        AwkValue v = AwkUndefined.UNDEF;
        AwkFiles f = null;
        try {
            r.setField("");
            InputStream rd = System.in;
            OutputStreamWriter so = new OutputStreamWriter(System.out);
            OutputStreamWriter se = new OutputStreamWriter(System.err);
            AwkLexer l = new AwkLexer("awk>", "  >>", new InputStreamReader(System.in));
            f = new AwkFiles(filesystem, rd, so, se);
            while (true) {
                try {
                    try {
                        v = AwkUndefined.UNDEF;
                        AwkExpression x = AwkParser.parseStatement(l);
                        x = x.compileInternally();
                        v = x.eval(r, f);
                        continue;
                    }
                    catch (AwkNextException awkNextException) {
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                    catch (AwkCompilationException e) {
                        System.err.print("Error: ");
                        System.err.println(e.getMessage());
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                    catch (AwkException e) {
                        System.err.print("Error: ");
                        System.err.println(e.getMessage());
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        ((Writer)so).flush();
                        ((Writer)se).flush();
                        System.out.println(v.toString());
                        l.resetPrompt();
                        continue;
                    }
                }
                finally {
                    ((Writer)so).flush();
                    ((Writer)se).flush();
                    System.out.println(v.toString());
                    l.resetPrompt();
                    continue;
                }
                break;
            }
        }
        catch (AwkExitException e) {
            System.exit(e.getValue().toInteger().intValue());
            if (f != null) {
                f.closeAll();
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace(System.err);
                System.exit(2);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (f != null) {
                    f.closeAll();
                }
            }
        }
    }

    public int invoke(ShFileSystem filesystem, ShFileGetter get, InputStream stdin, Writer stdout, Writer stderr, String ... args) throws IOException {
        String s;
        AwkFiles fs = new AwkFiles(filesystem, stdin, stdout, stderr);
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<Object> f = new ArrayList<Object>();
        String pfn = "<command line>";
        InputStream ins = null;
        boolean pre = false;
        AwkValue z = null;
        Reader r = null;
        int i = 1;
        HashMap<Object, Object> v = new HashMap<Object, Object>();
        while (i < args.length) {
            s = args[i];
            if (s.equals("--with-cpp")) {
                pre = true;
            } else if (s.equals("-f") && i + 1 < args.length) {
                ShFile d;
                if ((d = this.searchAwkPath(get, filesystem, s = (pfn = args[++i]))) == null) {
                    System.out.println(FILENOTFOUND + pfn);
                    return 2;
                }
                f.add(d);
            } else if (s.equals("-F") && i + 1 < args.length) {
                v.put("FS", args[++i]);
            } else if (s.startsWith("-F")) {
                v.put("FS", s.substring(2));
            } else if (s.equals("-v") && i + 1 < args.length) {
                int k;
                if ((k = (s = args[++i]).indexOf(61)) >= 0) {
                    v.put(s.substring(0, k), s.substring(k + 1));
                }
            } else if (s.equals("--source") && i + 1 < args.length) {
                s = args[++i];
                f.add(s);
            } else {
                if (s.equals("--version")) {
                    System.err.println("awkium Version 0.2.3");
                    return 1;
                }
                if (s.equals("--help") || s.equals("--usage")) {
                    this.usage();
                    return 1;
                }
                if (r != null) break;
                r = new StringReader(s);
            }
            ++i;
        }
        if (f.size() > 0) {
            r = FilesReader.newFiles(f);
        }
        if (pre) {
            r = new CPreprocessorReader(pfn, r);
        }
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        a.add(args[0]);
        while (i < args.length) {
            a.add(args[i]);
            ++i;
        }
        String[] a2 = a.toArray(new String[0]);
        AwkNamespace ns = Awk.newNamespace("<stdin>", a2);
        Awk.initvar(ns, v);
        EncodingDetector en = EncodingDetectorFactory.getInstance();
        if (r == null) {
            this.usage();
            return 2;
        }
        AwkProgram p = this.compile(ns, r);
        p.executeBegin(ns, fs);
        stdout.flush();
        stderr.flush();
        if (p.isExecuteOnce()) {
            return 0;
        }
        int j = 1;
        while (j < a.size()) {
            s = (String)a.get(j);
            int x = s.indexOf(61);
            if (x > 0) {
                ns.assign(s.substring(0, x), AwkString.valueOf(s.substring(x + 1)));
            } else {
                try {
                    ns.assign("FILENAME", AwkString.valueOf(s));
                    ns.assign("ARGIND", AwkInteger.valueOf(j));
                    Charset ch = en.detect(get.get(filesystem, s));
                    ins = get.get(filesystem, s).getInputStream();
                    z = this.execute(ns, fs, p, s, ins, stdout, stderr, ch, a2);
                }
                finally {
                    if (ins != null) {
                        ins.close();
                    }
                    ins = null;
                }
            }
            ++j;
        }
        if (z == null) {
            z = this.execute(ns, fs, p, "<stdin>", stdin, stdout, stderr, Charset.defaultCharset(), a2);
        }
        p.executeEnd(ns, fs);
        stdout.flush();
        stderr.flush();
        return z.toInteger().intValue();
    }

    @Override
    public int main(ShEnvironment env, ShFileSystem fs, InputStream in, PrintStream out, PrintStream err, String ... args) throws IOException {
        return this.invoke(fs, ShFileGetter.SH_FILE, in, new OutputStreamWriter(out), new OutputStreamWriter(err), args);
    }
}

