/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShFunction;
import net.morilib.sh.ShKeyword;
import net.morilib.sh.ShLexer;
import net.morilib.sh.ShPattern;
import net.morilib.sh.ShRedirector;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeAnd;
import net.morilib.sh.ShTreeBackground;
import net.morilib.sh.ShTreeBind;
import net.morilib.sh.ShTreeBlock;
import net.morilib.sh.ShTreeBreak;
import net.morilib.sh.ShTreeCase;
import net.morilib.sh.ShTreeContinue;
import net.morilib.sh.ShTreeEval;
import net.morilib.sh.ShTreeFor;
import net.morilib.sh.ShTreeIf;
import net.morilib.sh.ShTreeNot;
import net.morilib.sh.ShTreeOr;
import net.morilib.sh.ShTreePipe;
import net.morilib.sh.ShTreeRedirect;
import net.morilib.sh.ShTreeReturn;
import net.morilib.sh.ShTreeSimpleCommand;
import net.morilib.sh.ShTreeSource;
import net.morilib.sh.ShTreeSubprocess;
import net.morilib.sh.ShTreeType;
import net.morilib.sh.ShTreeWhileUntil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShParser {
    static void eatHeadId(ShLexer r, String s) throws IOException, ShSyntaxException {
        while (r.getToken().isEndOfLine()) {
            r.nextToken();
        }
        if (!r.getToken().equalsKeyword(s)) {
            throw new ShSyntaxException();
        }
    }

    static ShTree parseIf(ShLexer r) throws IOException, ShSyntaxException {
        ShToken t;
        ArrayList<ShTree> c = new ArrayList<ShTree>();
        ArrayList<ShTree> b = new ArrayList<ShTree>();
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        c.add(ShParser.parseCommand(r, r.nextToken()));
        while ((t = r.nextToken()).isEndOfLine()) {
        }
        r.eatId("then");
        while ((t = r.nextToken()).isEndOfLine()) {
        }
        while (true) {
            if (t == ShToken.EOF) {
                throw new ShSyntaxException();
            }
            if (t.equalsKeyword("fi")) {
                b.add(new ShTreeBlock(l));
                return new ShTreeIf(c, b, null);
            }
            if (t.equalsKeyword("else")) {
                b.add(new ShTreeBlock(l));
                return new ShTreeIf(c, b, ShParser.parseUntilKeyword(r, "fi"));
            }
            if (t.equalsKeyword("elif")) {
                b.add(new ShTreeBlock(l));
                l = new ArrayList();
                c.add(ShParser.parseCommand(r, r.nextToken()));
                while ((t = r.nextToken()).isEndOfLine()) {
                }
                ShParser.eatHeadId(r, "then");
                while ((t = r.nextToken()).isEndOfLine()) {
                }
                continue;
            }
            l.add(ShParser.parseCommand(r, t));
            t = r.nextToken();
        }
    }

    static ShPattern parsePattern(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ArrayList<ShToken> l = new ArrayList<ShToken>();
        ShToken s = t;
        while (s != ShToken.PAREN_E) {
            if (s.isString()) {
                l.add(s);
                s = r.nextToken();
                if (s == ShToken.PIPE) {
                    s = r.nextToken();
                    continue;
                }
                if (s == ShToken.PAREN_E) continue;
                throw new ShSyntaxException();
            }
            throw new ShSyntaxException();
        }
        return new ShPattern(l);
    }

    static ShTree parseCase(ShLexer r) throws IOException, ShSyntaxException {
        ShToken t;
        ArrayList<ShPattern> p = new ArrayList<ShPattern>();
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        ShToken s = r.nextToken();
        if (!s.isString()) {
            throw new ShSyntaxException();
        }
        r.nextToken();
        r.eatId("in");
        while (r.nextToken().isEndOfLine()) {
        }
        while (!(t = r.getToken()).equalsKeyword("esac")) {
            p.add(ShParser.parsePattern(r, t));
            l.add(ShParser.parseUntilToken(r, ShToken.CASEEND));
            while (r.nextToken().isEndOfLine()) {
            }
        }
        return new ShTreeCase(s, p, l);
    }

    static ShTree parseWhileUntil(ShLexer r, boolean until) throws IOException, ShSyntaxException {
        ShTree c = ShParser.parseCommand(r, r.nextToken());
        while (r.nextToken().isEndOfLine()) {
        }
        ShParser.eatHeadId(r, "do");
        ShTree b = ShParser.parseUntilKeyword(r, "done");
        return new ShTreeWhileUntil(c, b, until);
    }

    static List<ShToken> parseIdList(ShLexer r) throws IOException, ShSyntaxException {
        ArrayList<ShToken> l = new ArrayList<ShToken>();
        ShToken s;
        while ((s = r.nextToken()).precedence() <= 0) {
            l.add(s);
        }
        return l;
    }

    static ShTree parseFor(ShLexer r) throws IOException, ShSyntaxException {
        ShToken v = r.nextToken();
        if (!(v instanceof ShKeyword)) {
            throw new ShSyntaxException();
        }
        r.nextToken();
        r.eatId("in");
        List<ShToken> l = ShParser.parseIdList(r);
        while (r.nextToken().isEndOfLine()) {
        }
        ShParser.eatHeadId(r, "do");
        ShTree h = ShParser.parseUntilKeyword(r, "done");
        return new ShTreeFor(v, l, h);
    }

    static ShTree parseSimpleCommand(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ArrayList<ShRedirector> d = new ArrayList<ShRedirector>();
        ArrayList<ShToken> f = new ArrayList<ShToken>();
        ArrayList<ShToken> l = new ArrayList<ShToken>();
        ArrayList<ShToken> b = new ArrayList<ShToken>();
        ShToken s = t;
        while (true) {
            if (s.isFileRedirector()) {
                d.add((ShRedirector)s);
                f.add(r.nextId());
            } else if (s.isDescriptorCopier()) {
                d.add((ShRedirector)s);
                f.add(null);
            } else if (s.isHereDocument()) {
                d.add((ShRedirector)s);
                f.add(null);
            } else if (l.size() == 0 && s.isBind()) {
                b.add(s);
            } else {
                if (l.size() == 1 && l.get(0) instanceof ShKeyword && s == ShToken.PAREN_B) {
                    r.nextToken();
                    r.eat(ShToken.PAREN_E);
                    while ((t = r.nextToken()).isEndOfLine()) {
                    }
                    r.eatId("{");
                    ShTree x = ShParser.parseUntilKeyword(r, "}");
                    x = ShParser.parseStatRedirect(r, x);
                    return new ShFunction(((ShToken)l.get(0)).toString(), x);
                }
                if (s.precedence() <= 0) {
                    l.add(s);
                } else {
                    if (l.size() == 0) {
                        return new ShTreeBind(b);
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("break")) {
                        return new ShTreeBreak();
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("continue")) {
                        return new ShTreeContinue();
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("return")) {
                        if (l.size() > 1) {
                            return new ShTreeReturn((ShToken)l.get(1));
                        }
                        return new ShTreeReturn();
                    }
                    if (((ShToken)l.get(0)).equalsKeyword(".") || ((ShToken)l.get(0)).equalsKeyword("source")) {
                        if (l.size() > 1) {
                            return new ShTreeSource((ShToken)l.get(1));
                        }
                        return new ShTreeSource(null);
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("type")) {
                        if (l.size() > 1) {
                            return new ShTreeType((ShToken)l.get(1));
                        }
                        return new ShTreeType(new ShKeyword(""));
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("eval")) {
                        return new ShTreeEval(l);
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("builtin")) {
                        return new ShTreeSimpleCommand(l.subList(1, l.size()), d, f, b, 2);
                    }
                    if (((ShToken)l.get(0)).equalsKeyword("command")) {
                        return new ShTreeSimpleCommand(l.subList(1, l.size()), d, f, b, 6);
                    }
                    return new ShTreeSimpleCommand(l, d, f, b, 65535);
                }
            }
            s = r.nextToken();
        }
    }

    static ShTree parseTest(ShLexer r, String k) throws IOException, ShSyntaxException {
        ArrayList<ShRedirector> d = new ArrayList<ShRedirector>();
        ArrayList<ShToken> f = new ArrayList<ShToken>();
        ArrayList<ShToken> l = new ArrayList<ShToken>();
        l.add(new ShKeyword("test"));
        while (true) {
            ShToken s;
            if ((s = r.nextToken()) == ShToken.NEWLINE) {
                throw new ShSyntaxException();
            }
            if (s.equalsKeyword(k)) {
                return new ShTreeSimpleCommand(l, d, f, 65535);
            }
            l.add(s);
        }
    }

    static ShTree parseStatement(ShLexer r, ShToken s) throws IOException, ShSyntaxException {
        ShTree h;
        ShToken t = s;
        while (t == ShToken.NEWLINE) {
            t = r.nextToken();
        }
        if (t.equalsKeyword("{")) {
            r.addPrompt();
            h = ShParser.parseUntilKeyword(r, "}");
            r.removePrompt();
        } else if (t == ShToken.PAREN_B) {
            r.addPrompt();
            h = new ShTreeSubprocess(ShParser.parseUntilToken(r, ShToken.PAREN_E));
            r.removePrompt();
        } else if (t.equalsKeyword("if")) {
            r.addPrompt();
            h = ShParser.parseIf(r);
            r.removePrompt();
        } else if (t.equalsKeyword("case")) {
            r.addPrompt();
            h = ShParser.parseCase(r);
            r.removePrompt();
        } else if (t.equalsKeyword("while")) {
            r.addPrompt();
            h = ShParser.parseWhileUntil(r, false);
            r.removePrompt();
        } else if (t.equalsKeyword("until")) {
            r.addPrompt();
            h = ShParser.parseWhileUntil(r, true);
            r.removePrompt();
        } else if (t.equalsKeyword("for")) {
            r.addPrompt();
            h = ShParser.parseFor(r);
            r.removePrompt();
        } else if (t.equalsKeyword("[")) {
            h = ShParser.parseTest(r, "]");
        } else if (t.equalsKeyword("[[")) {
            h = ShParser.parseTest(r, "]]");
        } else {
            if (t.equalsKeyword("function")) {
                t = r.nextToken();
                if (!(t instanceof ShKeyword)) {
                    throw new ShSyntaxException();
                }
                while (r.nextToken().isEndOfLine()) {
                }
                r.eatId("{");
                ShTree h2 = ShParser.parseUntilKeyword(r, "}");
                h2 = ShParser.parseStatRedirect(r, h2);
                return new ShFunction(t.toString(), h2);
            }
            return ShParser.parseSimpleCommand(r, t);
        }
        return ShParser.parseStatRedirect(r, h);
    }

    static ShTree parsePipeCommand(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        ShToken s = t;
        while (true) {
            l.add(ShParser.parseStatement(r, s));
            s = r.getToken();
            if (s.precedence() > 10) {
                return l.size() < 2 ? (ShTree)l.get(0) : new ShTreePipe(l);
            }
            s = r.nextToken();
        }
    }

    static ShTree parseNot(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        boolean n = false;
        ShToken s = t;
        if (s.equalsKeyword("!")) {
            n = true;
            s = r.nextToken();
        }
        ShTree h = ShParser.parsePipeCommand(r, s);
        return n ? new ShTreeNot(h) : h;
    }

    static ShTree parseAnd(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        ShToken s = t;
        while (true) {
            l.add(ShParser.parseNot(r, s));
            s = r.getToken();
            if (s.precedence() > 30) {
                return l.size() < 2 ? (ShTree)l.get(0) : new ShTreeAnd(l);
            }
            s = r.nextToken();
        }
    }

    static ShTree parseOr(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        ShToken s = t;
        while (true) {
            l.add(ShParser.parseAnd(r, s));
            s = r.getToken();
            if (s.precedence() > 40) {
                return l.size() < 2 ? (ShTree)l.get(0) : new ShTreeOr(l);
            }
            s = r.nextToken();
        }
    }

    public static ShTree parseCommand(ShLexer r, ShToken t) throws IOException, ShSyntaxException {
        ShToken s = t;
        ShTree h = ShParser.parseOr(r, s);
        s = r.getToken();
        if (s == ShToken.FG || s == ShToken.NEWLINE || s == ShToken.CASEEND || s == ShToken.EOF) {
            return h;
        }
        if (s == ShToken.BG) {
            return new ShTreeBackground(h);
        }
        throw new ShSyntaxException();
    }

    static ShTree parseStatRedirect(ShLexer r, ShTree h) throws IOException, ShSyntaxException {
        ArrayList<ShRedirector> d = new ArrayList<ShRedirector>();
        ArrayList<ShToken> f = new ArrayList<ShToken>();
        ShToken s = r.nextToken();
        while (true) {
            if (s.isFileRedirector()) {
                d.add((ShRedirector)s);
                f.add(r.nextId());
            } else if (s.isDescriptorCopier()) {
                d.add((ShRedirector)s);
                f.add(null);
            } else {
                if (d.size() > 0) {
                    return new ShTreeRedirect(h, d, f);
                }
                return h;
            }
            s = r.nextToken();
        }
    }

    static ShTree parseUntilKeyword(ShLexer r, String s) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        while (true) {
            ShToken t;
            if ((t = r.nextToken()).isEndOfLine()) {
                continue;
            }
            if (t == ShToken.EOF) {
                throw new ShSyntaxException();
            }
            if (t.equalsKeyword(s)) break;
            l.add(ShParser.parseCommand(r, t));
        }
        return new ShTreeBlock(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ShTree parseUntilToken(ShLexer r, ShToken s) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        while (true) {
            ShToken t;
            if ((t = r.nextToken()).isEndOfLine()) {
                continue;
            }
            if (t == ShToken.EOF) {
                throw new ShSyntaxException();
            }
            if (r.getToken().equals(s)) return new ShTreeBlock(l);
            l.add(ShParser.parseStatement(r, t));
            if (r.getToken().equals(s)) return new ShTreeBlock(l);
        }
    }

    static ShTree parseScript(ShLexer r) throws IOException, ShSyntaxException {
        ArrayList<ShTree> l = new ArrayList<ShTree>();
        while (true) {
            ShToken t;
            if ((t = r.nextToken()) == ShToken.NEWLINE) {
                continue;
            }
            if (t == ShToken.EOF) {
                return new ShTreeBlock(l);
            }
            l.add(ShParser.parseCommand(r, t));
        }
    }

    public static ShTree parse(Reader reader) throws IOException, ShSyntaxException {
        ShLexer l = new ShLexer(new PushbackReader(reader));
        l.skipws();
        return ShParser.parseScript(l);
    }

    public static ShTree parse(InputStream input, Charset cset) throws IOException, ShSyntaxException {
        return ShParser.parse(new InputStreamReader(input, cset));
    }

    public static ShTree parse(String script) throws IOException, ShSyntaxException {
        ShLexer l = new ShLexer(new PushbackReader(new StringReader(script)));
        l.skipws();
        return ShParser.parseScript(l);
    }
}

