/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShTreeFor
implements ShTree {
    private ShToken variable;
    private List<ShToken> list;
    private ShTree block;

    public ShTreeFor(ShToken variable, List<ShToken> list, ShTree block) {
        this.variable = variable;
        this.list = list;
        this.block = block;
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream in, PrintStream out, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        String n = this.variable.toString();
        int a = 0;
        List<String> l = ShTrees.substitute(env, run, fs, err, p, this.list);
        for (String s : l) {
            env.put(n, s);
            a = this.block.eval(env, fs, cmds, run, in, out, err, p);
        }
        return a;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        Object r = new Object();
        Object c = new Object();
        b.addPushin(this.list);
        b.addLabel(c);
        b.addGetin(this.variable.toString(), r);
        this.block.compileInternally(b, r, c);
        b.addJmp(c);
        b.addLabel(r);
    }

    public String toString() {
        StringBuffer b = new StringBuffer("for ");
        b.append(this.variable).append(" in");
        for (ShToken t : this.list) {
            b.append(" ").append(t);
        }
        b.append("\ndo\n").append(this.block);
        return b.append("\ndone").toString();
    }
}

