/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.exe;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import net.morilib.sh.DefaultShRuntime;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShCommandNotFoundException;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShError;
import net.morilib.sh.ShErrorHandler;
import net.morilib.sh.ShExitException;
import net.morilib.sh.ShFacade;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShLexer;
import net.morilib.sh.ShParser;
import net.morilib.sh.ShPromptReader;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.exe.ShDefaultBuiltInCommands;
import net.morilib.sh.file.ShFileSystemFactory;
import net.morilib.sh.misc.ConsoleInputStream;
import net.morilib.sh.misc.XtraceStream;
import net.morilib.unix.misc.OptionIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sh {
    public static final ShErrorHandler INTERACTIVE = new ShErrorHandler(){

        public void handle(ShError e) {
            e.printStackTrace();
            System.err.println("Syntax error");
        }
    };
    public static final ShRuntime RUNTIME = new DefaultShRuntime(ShDefaultBuiltInCommands.getInstance());

    private static void exechandle(ShErrorHandler h, ShError e) {
        if (h == null) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        h.handle(e);
    }

    private static void _setarg(ShEnvironment n, Iterator<String> a) {
        int i = 1;
        while (a.hasNext()) {
            n.put(String.valueOf(i), a.next());
            ++i;
        }
    }

    public static int interactive(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream stdin, PrintStream stdout, PrintStream stderr, XtraceStream prompt, ShPromptReader p) throws IOException {
        int a = 0;
        ShLexer r = new ShLexer(env, p, prompt);
        while (true) {
            try {
                ShToken t;
                while ((t = r.nextToken()) == ShToken.NEWLINE) {
                }
                ShTree x = ShParser.parseCommand(r, t);
                a = x.eval(env, fs, cmds, run, stdin, stdout, stderr, prompt);
                if (r.isEof()) {
                    return a;
                }
                r.resetPrompt();
                continue;
            }
            catch (IOException e) {
                String z = env.getTrap(ShSignal.IO);
                if (z != null) {
                    try {
                        RUNTIME.eval(env, fs, stdin, stdout, stderr, prompt, z);
                    }
                    catch (ShCommandNotFoundException e1) {
                        stderr.print("jsh");
                        stderr.print(": command not found: ");
                        stderr.println(e1.getName());
                    }
                    catch (IOException e1) {
                        stderr.print("jsh");
                        stderr.println(": IO error");
                    }
                    catch (ShSyntaxException e1) {
                        Sh.exechandle(INTERACTIVE, e1);
                    }
                }
                e.printStackTrace(System.err);
                continue;
            }
            catch (ShCommandNotFoundException e) {
                stderr.print("jsh");
                stderr.print(": command not found: ");
                stderr.println(e.getName());
                continue;
            }
            catch (ShSyntaxException e) {
                Sh.exechandle(INTERACTIVE, e);
                continue;
            }
            catch (ShRuntimeException e) {
                Sh.exechandle(INTERACTIVE, e);
                continue;
            }
            break;
        }
    }

    public static int interactive(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream stdin, PrintStream stdout, PrintStream stderr, XtraceStream prompt) throws IOException {
        return Sh.interactive(env, fs, cmds, run, stdin, stdout, stderr, prompt, new ShPromptReader(env, prompt));
    }

    public static int interactive(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream lex, ShErrorHandler errhandle, InputStream in, PrintStream out, PrintStream err, XtraceStream q) {
        try {
            ShFacade.execute(env, fs, cmds, run, fs.getProfile(), in, out, err, q);
            return Sh.interactive(env, fs, cmds, run, in, out, err, q);
        }
        catch (ShCommandNotFoundException e) {
            err.print("jsh");
            err.print(": command not found: ");
            err.println(e.getName());
            return 2;
        }
        catch (ShSyntaxException e) {
            Sh.exechandle(INTERACTIVE, e);
            return 2;
        }
        catch (ShRuntimeException e) {
            Sh.exechandle(INTERACTIVE, e);
            return 2;
        }
        catch (ShExitException e) {
            return e.getCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int execute(Reader script, InputStream in, PrintStream out, PrintStream err) throws IOException, ShSyntaxException {
        ShBuiltInCommands b = ShDefaultBuiltInCommands.getInstance();
        ShFileSystem f = ShFileSystemFactory.getInstance();
        ShRuntime m = RUNTIME;
        PushbackReader p = null;
        int z = 0;
        ShEnvironment v = ShFileSystemFactory.getSystemEnvironment();
        v = new ShRootShellEnvironment(v);
        v.bind("PS1", "$ ");
        v.bind("PS2", "> ");
        f.setCurrentDirectory(f.getHome());
        XtraceStream q = new XtraceStream(System.out);
        try {
            if (script == null) {
                throw new NullPointerException();
            }
            ShTree x = ShParser.parse(script);
            z = x.eval(v, f, b, m, in, out, err, q);
        }
        finally {
            if (p != null) {
                try {
                    p.close();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return z;
    }

    public static int invoke(String[] args) {
        PrintStream err;
        PrintStream out;
        ShBuiltInCommands b = ShDefaultBuiltInCommands.getInstance();
        ShFileSystem f = ShFileSystemFactory.getInstance();
        ShRuntime m = RUNTIME;
        FileInputStream ins = null;
        int z = 0;
        ShEnvironment v = ShFileSystemFactory.getSystemEnvironment();
        v = new ShRootShellEnvironment(v);
        v.bind("PS1", "$ ");
        v.bind("PS2", "> ");
        f.setCurrentDirectory(f.getHome());
        XtraceStream q = new XtraceStream(System.out);
        boolean fs = false;
        boolean fc = false;
        OptionIterator o = new OptionIterator("Cfnuvxo:c:s", true, args);
        while (o.hasNext()) {
            switch (o.nextChar()) {
                case 'C': {
                    v.set("noclobber", !o.isPlus());
                    break;
                }
                case 'f': {
                    v.set("noglob", !o.isPlus());
                    break;
                }
                case 'n': {
                    v.set("noexec", !o.isPlus());
                    break;
                }
                case 'u': {
                    v.set("nounset", !o.isPlus());
                    break;
                }
                case 'v': {
                    v.set("verbose", !o.isPlus());
                    break;
                }
                case 'x': {
                    v.set("xtrace", !o.isPlus());
                    break;
                }
                case 'c': {
                    fc = true;
                    break;
                }
                case 's': {
                    fs = true;
                }
            }
        }
        try {
            out = new PrintStream((OutputStream)System.out, true, v.getCharset().toString());
            err = new PrintStream((OutputStream)System.err, true, v.getCharset().toString());
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        try {
            ShFacade.execute(v, f, b, m, f.getProfile(), System.in, out, err, q);
        }
        catch (IOException e) {
            e.printStackTrace(err);
        }
        catch (ShCommandNotFoundException e) {
            err.print("jsh");
            err.print(": command not found: ");
            err.println(e.getName());
        }
        catch (ShSyntaxException e) {
            Sh.exechandle(INTERACTIVE, e);
        }
        catch (ShRuntimeException e) {
            Sh.exechandle(INTERACTIVE, e);
        }
        try {
            String s;
            Iterator<String> a = o.filenameIterator();
            if (fc) {
                s = o.getArgument();
                a = o.filenameIterator();
                Sh._setarg(v, a);
                z = m.eval(v, f, System.in, out, err, q, s);
            } else if (fs) {
                s = o.getArgument();
                a = o.filenameIterator();
                Sh._setarg(v, a);
                z = Sh.interactive(v, f, b, m, ConsoleInputStream.console(), INTERACTIVE, System.in, out, err, q);
            } else if (a.hasNext()) {
                try {
                    s = a.next();
                    ins = new FileInputStream(s);
                    Sh._setarg(v, a);
                    z = ShFacade.execute(v, f, b, m, ins, System.in, out, err, q);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else {
                z = Sh.interactive(v, f, b, m, ConsoleInputStream.console(), INTERACTIVE, System.in, out, err, q);
            }
            int n = z;
            return n;
        }
        catch (IOException e) {
            String s = v.getTrap(ShSignal.IO);
            if (s != null) {
                try {
                    RUNTIME.eval(v, f, System.in, out, err, q, s);
                }
                catch (ShCommandNotFoundException e1) {
                    err.print("jsh");
                    err.print(": command not found: ");
                    err.println(e1.getName());
                }
                catch (IOException e1) {
                    throw new RuntimeException(e);
                }
                catch (ShSyntaxException e1) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
        catch (ShSyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            String s = v.getTrap(ShSignal.EXIT);
            if (s != null) {
                try {
                    m.eval(v, f, System.in, out, err, q, s);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ShSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

