/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PipeBuffer {
    private static final int BUFSIZE = 8192;
    private int point = 0;
    private int readp = 0;
    private byte[] buffer;
    private File tmpfile = null;
    private InputStream tins;
    private OutputStream tous;
    private InputStream input = null;
    private OutputStream output = new Out();

    public PipeBuffer(int size) {
        this.buffer = new byte[size];
    }

    public PipeBuffer() {
        this(8192);
    }

    private void createtmp() throws IOException {
        if (this.tmpfile == null) {
            this.tmpfile = File.createTempFile("jsh", ",tmp");
            this.tous = new FileOutputStream(this.tmpfile);
            this.tous.write(this.buffer, 0, this.point);
        }
    }

    private void checkOutput() {
        if (this.output == null) {
            throw new IllegalStateException();
        }
    }

    private void checkInput() {
        if (this.input == null) {
            throw new IllegalStateException();
        }
    }

    public OutputStream getOutputStream() {
        if (this.output == null) {
            throw new IllegalStateException();
        }
        return this.output;
    }

    public InputStream getInputStream() {
        try {
            if (this.input != null) {
                return this.input;
            }
            if (this.output != null) {
                throw new IllegalStateException();
            }
            if (this.tmpfile != null) {
                this.tins = new FileInputStream(this.tmpfile);
            }
            this.input = new In();
            return this.input;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        if (this.input != null || this.output != null) {
            throw new IllegalStateException();
        }
        this.point = 0;
        this.readp = 0;
        this.tmpfile = null;
    }

    public void close() {
        try {
            if (this.tins != null) {
                this.tins.close();
            }
            if (this.tous != null) {
                this.tous.close();
            }
            this.tins = null;
            this.tous = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class In
    extends InputStream {
        private In() {
        }

        public int read() throws IOException {
            PipeBuffer.this.checkInput();
            if (PipeBuffer.this.tmpfile != null) {
                return PipeBuffer.this.tins.read();
            }
            if (PipeBuffer.this.readp < PipeBuffer.this.point) {
                byte[] byArray = PipeBuffer.this.buffer;
                PipeBuffer pipeBuffer = PipeBuffer.this;
                int n = pipeBuffer.readp;
                pipeBuffer.readp = n + 1;
                return byArray[n];
            }
            return -1;
        }

        public int available() throws IOException {
            PipeBuffer.this.checkInput();
            return PipeBuffer.this.tmpfile != null ? PipeBuffer.this.tins.available() : PipeBuffer.this.point - PipeBuffer.this.readp;
        }

        public void close() throws IOException {
            PipeBuffer.this.checkInput();
            if (PipeBuffer.this.tmpfile != null) {
                PipeBuffer.this.tins.close();
            }
            PipeBuffer.this.input = null;
        }

        public int read(byte[] b, int off, int l) throws IOException {
            int p = PipeBuffer.this.readp;
            PipeBuffer.this.checkInput();
            if (PipeBuffer.this.tmpfile != null) {
                return PipeBuffer.this.tins.read(b, off, l);
            }
            if (PipeBuffer.this.readp + l < PipeBuffer.this.point) {
                System.arraycopy(PipeBuffer.this.buffer, PipeBuffer.this.readp, b, off, l);
                PipeBuffer pipeBuffer = PipeBuffer.this;
                pipeBuffer.readp = pipeBuffer.readp + l;
                return l;
            }
            if (PipeBuffer.this.readp < PipeBuffer.this.point) {
                System.arraycopy(PipeBuffer.this.buffer, PipeBuffer.this.readp, b, off, PipeBuffer.this.point - PipeBuffer.this.readp);
                PipeBuffer pipeBuffer = PipeBuffer.this;
                pipeBuffer.readp = pipeBuffer.readp + l;
                return PipeBuffer.this.point - p;
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            int p = PipeBuffer.this.readp;
            PipeBuffer.this.checkInput();
            if (PipeBuffer.this.tmpfile != null) {
                return PipeBuffer.this.tins.skip(n);
            }
            if ((long)PipeBuffer.this.readp + n < (long)PipeBuffer.this.point) {
                PipeBuffer pipeBuffer = PipeBuffer.this;
                pipeBuffer.readp = (int)((long)pipeBuffer.readp + n);
                return n;
            }
            if (PipeBuffer.this.readp < PipeBuffer.this.point) {
                PipeBuffer pipeBuffer = PipeBuffer.this;
                pipeBuffer.readp = (int)((long)pipeBuffer.readp + n);
                return PipeBuffer.this.point - p;
            }
            return -1L;
        }
    }

    private class Out
    extends OutputStream {
        private Out() {
        }

        public void write(int b) throws IOException {
            PipeBuffer.this.checkOutput();
            if (PipeBuffer.this.tmpfile == null && PipeBuffer.this.point + 1 < PipeBuffer.this.buffer.length) {
                byte[] byArray = PipeBuffer.this.buffer;
                PipeBuffer pipeBuffer = PipeBuffer.this;
                int n = pipeBuffer.point;
                pipeBuffer.point = n + 1;
                byArray[n] = (byte)b;
            } else {
                PipeBuffer.this.createtmp();
                PipeBuffer.this.tous.write(b);
            }
        }

        public void close() throws IOException {
            PipeBuffer.this.checkOutput();
            if (PipeBuffer.this.tmpfile != null) {
                PipeBuffer.this.tous.close();
            }
            PipeBuffer.this.output = null;
        }

        public void flush() throws IOException {
            PipeBuffer.this.checkOutput();
            if (PipeBuffer.this.tmpfile != null) {
                PipeBuffer.this.tous.flush();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            PipeBuffer.this.checkOutput();
            if (PipeBuffer.this.tmpfile == null && PipeBuffer.this.point + len < PipeBuffer.this.buffer.length) {
                System.arraycopy(b, off, PipeBuffer.this.buffer, PipeBuffer.this.point, len);
                PipeBuffer pipeBuffer = PipeBuffer.this;
                pipeBuffer.point = pipeBuffer.point + len;
            } else {
                PipeBuffer.this.createtmp();
                PipeBuffer.this.tous.write(b, off, len);
            }
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }
}

