/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.b;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

import net.morilib.awk.AwkRuntimeException;
import net.morilib.awk.builtin.AwkQuaternaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数b.tostringの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/27
 */
public class BTostring extends AwkQuaternaryArgs {

	protected BTostring() {
		super("tostring");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3, AwkValue a4) {
		StringBuffer b = new StringBuffer();
		String s = a1.toString(), t;
		int bg, ed;
		Charset c;
		byte[] a;

		try {
			a = s.getBytes("ISO-8859-1");
		} catch (UnsupportedEncodingException e1) {
			throw new RuntimeException(e1);
		}

		if(a2 instanceof AwkUndefined) {
			bg = 0;
			ed = a.length;
			c  = Charset.defaultCharset();
		} else if(a3.isInteger()) {
			bg = AwkBBuiltInLoader.index(a2) - 1;
			ed = AwkBBuiltInLoader.index(a3) - 1;
			c  = AwkBBuiltInLoader.charset(a4);
		} else if(a2.isInteger()) {
			bg = AwkBBuiltInLoader.index(a2) - 1;
			ed = a.length;
			c  = AwkBBuiltInLoader.charset(a3);
		} else {
			bg = 0;
			ed = a.length;
			c  = AwkBBuiltInLoader.charset(a2);
		}

		// trims null trailer
		if(bg < 0 || bg > a.length) {
			throw new AwkRuntimeException("index out of bounds");
		} else if(ed < 0 || ed > a.length) {
			throw new AwkRuntimeException("index out of bounds");
		} else if(bg > ed) {
			throw new AwkRuntimeException("index out of bounds");
		}

		t = new String(a, bg, ed - bg, c);
		for(int i = 0; i < t.length() && t.charAt(i) > 0; i++) {
			b.append(t.charAt(i));
		}
		return AwkString.valueOf(b.toString());
	}

}
