/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.m;

import net.morilib.awk.builtin.AwkMathFunction;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkValue;

public class MAbs extends AwkMathFunction {

	protected MAbs() {
		super("abs");
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.builtin.AwkMathFunction#f(net.morilib.awk.value.AwkValue)
	 */
	@Override
	protected AwkValue f(AwkValue x) {
		double a, b;

		if(x.isInteger()) {
			return AwkInteger.valueOf(x.toInteger().abs());
		} else {
			a = x.toFloat();
			b = x.toImaginary();
			return AwkFloat.valueOf(Math.sqrt(a * a + b * b));
		}
	}

}
