/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShProcess;

public class ShBasename implements ShProcess {

	private static final Pattern PTN = Pattern.compile("([^/]*)/*$");

	public int main(ShEnvironment env, ShFileSystem fs, InputStream in,
			PrintStream out, PrintStream err,
			String... args) throws IOException {
		Matcher m;
		String s;

		if(args.length < 2) {
			err.println("basename: illegal argument");
			return 2;
		} else {
			s = args[1];
			m = PTN.matcher(s);
			s = m.find() ? m.group(1) : s;
			if(args.length >= 3 && s.endsWith(args[2])) {
				s = s.substring(0, s.length() - args[2].length());
			}
			out.println(s);
			return 0;
		}
	}

}
