<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
class UFile {		//ファイル情報クラス（構造体）
	var	$mName;		//一覧表用
	var	$mPath;		//プログラム上のパス
	var $mFullPath;	//実際のフルパス
	var	$mKind;
	var	$mSize;
	var	$mKBSize;	//一覧表用
	var	$mMTime;
	var	$mDate;		//一覧表用
}
//---------------------------------------------------------------------------
function ListFiles($pDir)
//ディレクトリ内のファイル一覧表を出力する
//引数		$pDir：パス $gRootDir . $pDir で絶対パスを作る
//			$_COOKIE['cSort'] : ソート方法
//プログラム上のルートディレクトリは / となる
{
	global	$gMsg,$gLang,$gCharSet,$gRootDir,$gOverWrite;

//-------------処理部-------------
	$result = ScanFiles($pDir,$aDirs,$aFiles);	//$pDirのディレクトリとファイル一覧を得る
	$CurDir = mb_convert_encoding($pDir,"UTF-8",$gCharSet);

	if($result) {
		if(isset($_COOKIE['cSort'])) {
			switch($_COOKIE['cSort']) {
				case 'name_up':		usort($aDirs,"CmpByName"); usort($aFiles,"CmpByName");break;
				case 'name_down':	usort($aDirs,"CmpByNameR");usort($aFiles,"CmpByNameR");break;
				case 'size_up':		usort($aDirs,"CmpBySize"); usort($aFiles,"CmpBySize");break;
				case 'size_down':	usort($aDirs,"CmpBySizeR");usort($aFiles,"CmpBySizeR");break;
				case 'date_up':		usort($aDirs,"CmpByDate"); usort($aFiles,"CmpByDate");break;
				case 'date_down':	usort($aDirs,"CmpByDateR");usort($aFiles,"CmpByDateR");break;
				default:			usort($aDirs,"CmpByDateR");usort($aFiles,"CmpByDateR");break;
			}
		} else {
			usort($aDirs,"CmpByDateR");usort($aFiles,"CmpByDateR");
		}
		MakeDirArray($CurDir,$aDirList);	//現在のディレクトリ一覧を作る
	}

	$UploadMaxFilesize  = get_cfg_var("upload_max_filesize");
	$MAX_FILE_SIZE      = $UploadMaxFilesize * 1000000;
	if($gOverWrite) $msg_up_mode = "<input id=\"iOverWrite\" type=\"checkbox\" name=\"nOverWrite\" value=\"1\" checked=\"checked\">";
	  else          $msg_up_mode = "<input id=\"iOverWrite\" type=\"checkbox\" name=\"nOverWrite\" value=\"1\">";

//-------------表示部-------------

//ディレクトリがない場合 = 設定がおかしい場合
	if($result == false) {
		include("prog/html01.inc");		//HEADER部分
		printf($gMsg['NoFolder'],$gRootDir,$pDir);
		include("prog/html04.inc");
		return;
	}

//設定が正しい場合
	include("prog/html01.inc");		//HEADER部分
	include("prog/html02.inc");		//メインウインドウの上部

	foreach($aDirs as $key => $val) {	//ディレクトリ一覧表出力
		print <<< ListFiles2
<tr>
<td><input type="checkbox" name="nDirs[]" value="{$val->mName}/"></td>
<td><span class="cPseudLinkMoveDir" onclick="MoveDirB('{$val->mName}/')"><img src="prog/img/dir1.gif" alt="">{$val->mName}</span></td>
<td style="text-align:center;">---</td>
<td style="text-align:right;">{$val->mDate}</td>
</tr>

ListFiles2;
	}

	foreach($aFiles as $key => $val) {//ファイル一覧表出力
		print <<< ListFiles3
<tr>
<td><input type="checkbox" name="nFiles[]" value="{$val->mName}"></td>
<td><span class="cPseudLinkDownLoad" onclick="DownLoad('{$val->mName}')"><img src="prog/img/file1.gif" alt="">{$val->mName}</span></td>
<td style="text-align:right;">{$val->mKBSize}</td>
<td style="text-align:right;">{$val->mDate}</td>
</tr>

ListFiles3;
	}

	include("prog/html03.inc");		//メインウインドウの下部
	include("prog/html04.inc");		//フッタ
}
//---------------------------------------------------------------------------
function ScanFiles($pPath,&$pDirs,&$pFiles)
//ディレクトリ内のファイル一覧を取得する
//引数		$pPath：一覧表を作るディレクトリのフルパス
//			&$pDirs,&$pFiles：ディレクトリとファイルの情報を入れて戻す
//戻り値	true：成功　false：エラーが起きた
{
	global	$gRootDir,$gCharSet;

	$pDirs  = array();
	$pFiles = array();

	if (!($dh = @opendir($gRootDir . $pPath))) {
		return(false);
	}
	while (false !== ($file = readdir($dh))) {
		if($file == '.' || $file == '..') continue;
		$tmp            = new UFile;
		$tmp->mName     = mb_convert_encoding($file,"UTF-8",$gCharSet);
		$fullpath       = $gRootDir . $pPath . $file;
		$tmp->mKind     = filetype($fullpath);
		if($tmp->mKind == 'dir') $fullpath = $fullpath . '/';
		$tmp->mPath     = $pPath;
		$tmp->mFullPath = $fullpath ;
		$tmp->mSize     = filesize($fullpath);
		$tmp->mKBSize   = round(($tmp->mSize/1024)) . ' kB';
		$tmp->mMTime    = filemtime($fullpath);
		$tmp->mDate     = date("Y/m/d H:i", $tmp->mMTime);
		if($tmp->mKind == 'dir')  $pDirs[]  = $tmp;
		if($tmp->mKind == 'file') $pFiles[] = $tmp;
	}
	closedir($dh);

	return(true);
}
//---------------------------------------------------------------------------
function CmpByName($a,$b)
{
	if ($a->mName == $b->mName) {
		return 0;
	}
	return ($a->mName < $b->mName) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpBySize($a,$b)
{
	if ($a->mSize == $b->mSize) {
		return 0;
	}
	return ($a->mSize < $b->mSize) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpByDate($a,$b)
{
	if ($a->mMTime == $b->mMTime) {
		return 0;
	}
	return ($a->mMTime < $b->mMTime) ? -1 : 1;
}
//---------------------------------------------------------------------------
function CmpByNameR($a,$b)
{
	if ($a->mName == $b->mName) {
		return 0;
	}
	return ($a->mName < $b->mName) ? 1 : -1;
}
//---------------------------------------------------------------------------
function CmpBySizeR($a,$b)
{
	if ($a->mSize == $b->mSize) {
		return 0;
	}
	return ($a->mSize < $b->mSize) ? 1 : -1;
}
//---------------------------------------------------------------------------
function CmpByDateR($a,$b)
{
	if ($a->mMTime == $b->mMTime) {
		return 0;
	}
	return ($a->mMTime < $b->mMTime) ? 1 : -1;
}
//---------------------------------------------------------------------------
function MakeDirArray($pDir,&$pRet)
//現在のディレクトリ一覧を作る
//引数		$pDir：ディレクトリ
//			&$pRet：結果を入れて返す
{
	global	$gMsg;

	$tmp  = "/";
	$pRet = "<span class=\"cPseudLinkMoveDir\" onclick=\"MoveDirA('/')\"><img src=\"prog/img/root.gif\" alt=\"\">" . $gMsg['root'] . "</span> / \n";

	$d = explode('/',$pDir);
	$c = count($d);
	for($i=1;$i<$c - 1;$i++) {
		$tmp = $tmp . $d[$i] . '/';
		$pRet = $pRet . "<span class=\"cPseudLinkMoveDir\" onclick=\"MoveDirA('{$tmp}')\"><img src=\"prog/img/dir1.gif\" alt=\"\">{$d[$i]}</span> / \n";
	}
}
//---------------------------------------------------------------------------
?>
