<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//---------------------------------------------------------------------------
function IsText()
//ファイルを編集できるかどうか Ajaxで答える
//引数		$_POST['nFileName'] : ファイル名
{
	include('prog/extlist.inc');

	$FilePath = pathinfo($_POST['nFileName']);
	if(! isset($FilePath['extension'])) {
		echo "Not Text";
		return;
	}

	$ext = $FilePath['extension'];
	foreach($gTextFile as $val) {
		if($val == $ext) {
			echo "TEXT";
			return;
		}
	}
	echo "Not Text";
}
//---------------------------------------------------------------------------
function EditText()
//テキストファイルを編集するために別ウインドウで表示
//引数		$_GET['nFileName'] : ファイル名
//			$_GET['nDir'] : 現在のディレクトリ $gRootDir . $_GET['nDir'] . $_GET['nFileName']でフルパスになる
{
	global	$gLang,$gMsg,$gRootDir,$gCharSet;

	$dir      = mb_convert_encoding($_GET['nDir'],"UTF-8",$gCharSet);		//表示する名前
	$filename = mb_convert_encoding($_GET['nFileName'],"UTF-8",$gCharSet);
	$title = "Edit Text : " . $filename;

	include('prog/html05.inc');
	print <<< kEditText
<script type="text/javascript">
<!--
$(document).ready(function () {
	var rows;

	$.ajaxSetup({async : false});
	rows = $("#iRows").val();
	if(rows >= 40) rows = "40em";
	  else		   rows = rows + "em";
	$("#iTextData").height(rows);
});

function UpdateText()	//更新実行
{
	var data,result;

	data = $("#iEditText").serialize();
	$.post("index.php",data , function (ret) {
		result = ret;
	},"text");
	if(result == 'OK')	alert('{$gMsg['CompUpdate']}');
	  else				alert(result);
}

//-->
</script>

<div id="iHeader">
{$gMsg['EditFile']}{$filename}
</div>

<form id="iEditText" method="post" action="index.php">
<input type="hidden" name="nCmd"      value="UpdateText">
<input type="hidden" name="nDir"      value="{$dir}">
<input type="hidden" name="nFileName" value="{$filename}">
<span style="font-size : 0.8em">{$gMsg['UpdateCaution']}</span><br>
<input type="button" value="{$gMsg['CloseButton']}"  onclick="window.close()">
<input type="button" value="{$gMsg['UpdateButton']}" onclick="UpdateText()">
<span style="font-size : 0.8em">{$gMsg['EditCaution']}</span>
<br>
<textarea id="iTextData" name="nTextData"  style="width : 95%;font-size : 1em">
kEditText;

	$text = @file_get_contents($gRootDir . $_GET['nDir'] . $_GET['nFileName']);
	if($text == false) {
		$charset = "SJIS";
		printf($gMsg['CanNotOpen'],$filename);
		$c = 5;
	} else {
		$charset = mb_detect_encoding($text,"JIS,SJIS,UTF-8,EUC-JP,ASCII");	//autoはうまくいかないことがある
		$text    = mb_convert_encoding($text,"UTF-8",$charset);				//編集のために文字コードを変える
		echo $text;
		$n  = substr_count($text,"\n");	//改行コードを調べる
		$r  = substr_count($text,"\r");
		$rn = substr_count($text,"\r\n");
		$c    = 5;
		$CRLF = 'CRLF';
		if($rn > 0) {
			$c = $c + $rn;
			$CRLF = 'rn';
		} else {
			if($n > 0) {
				$c = $c + $n;
				$CRLF = 'n';
			} else {
				$c = $c + $r;
				$CRLF = 'r';
			}
		}
	}

	print <<< kEditText2
</textarea>
<input type="hidden" id="iCharSet" name="nCharSet" value="{$charset}">
<input type="hidden" id="iRows"    name="nRows"    value="{$c}">
<input type="hidden"               name="nCRLF"    value="{$CRLF}">
</form>

kEditText2;

	printf("<span style=\"font-size : 0.8em\">");
	printf($gMsg['DetectChar'],$charset);
	printf("</span>\n</body>\n</html>\n");
}
//---------------------------------------------------------------------------
function UpdateText()
//テキストファイルを更新する
//引数		$_POST['nDir']		: 現在のディレクトリ
//			$_POST['nFileName']	: ファイル名
//			$_POST['nTextData']	: データ
//			$_POST['nCharSet']	: 文字コード
//			$_POST['nCRLF']		: 改行コード
{
	global $gRootDir,$gCharSet,$gMsg;

	$fname = mb_convert_encoding($_POST['nFileName'],"UTF-8",$gCharSet);

	$data = mb_convert_encoding($_POST['nTextData'],$_POST['nCharSet'],$gCharSet);
	switch($_POST['nCRLF']) {
		case 'r':	$data = str_replace("\n","\r",$data);break;
		case 'n':	$data = str_replace("\n","\n",$data);break;
		case 'rn':	$data = str_replace("\n","\r\n",$data);break;
	}
	$ret = file_put_contents($gRootDir . $_POST['nDir'] . $_POST['nFileName'] ,$data);
	if($ret == false) {
		printf($gMsg['UpdateFail'],$fname);
		return;
	}

	echo 'OK';
}
//---------------------------------------------------------------------------
?>
