<?php
//---------------------------------------------------------------------------
//Charactor set is UTF-8
//漢字コードはＵＴＦ－８
//この行はエディターに文字コードを認識させるためのおまじない
//---------------------------------------------------------------------------
require('prog/axlope15.inc');
//---------------------------------------------------------------------------
function CopyFiles()
//ファイルを複写する
//引数	$gRootDir:ルートディレクトリ
//		$_POST['nDir']		: 現在のディレクトリ
//		$_POST['nSelDir']	: 複写先ディレクトリ
//		$_POST['nFiles']	: 複写するファイル
{
	global	$gRootDir;

	if(! isset($_POST['nFiles'])) return;
	foreach($_POST['nFiles'] as $f) {
		$fname = UniqName($gRootDir. $_POST['nSelDir'],$f);
		copy($gRootDir. $_POST['nDir']  . $f , $gRootDir. $_POST['nSelDir'] . $fname);
	}
}
//---------------------------------------------------------------------------
function CopyDirs()
//複写処理
//引数	$gRootDir:ルートディレクトリ
//		$_POST['nDir']		: 現在のディレクトリ
//		$_POST['nSelDir']	: 複写先ディレクトリ
//		$_POST['nDirs']		: 複写するディレクトリ
{
	global	$gRootDir;

	if(! isset($_POST['nDirs'])) return;
	foreach($_POST['nDirs'] as $f) {
		if($_POST['nDir'] . $f == $_POST['nSelDir'] ) continue;	//複写元と複写先が同じディレクトリなら何もしない
		$fname = UniqDirName($gRootDir. $_POST['nSelDir'],$f);
		recurse_copy($gRootDir. $_POST['nDir'] . $f , $gRootDir. $_POST['nSelDir'] . $fname);
	}
}
//---------------------------------------------------------------------------
function recurse_copy($src,$dst)
//再帰的ディレクトリーコピー
//出典：PHPマニュアル
//引数	$src : コピー元ディレクトリ(最後の / 付き)
//		$dst : コピー先ディレクトリ(最後の / 付き)
{
	mkdir($dst);

	$dir = opendir($src);
	while(false !== ($file = readdir($dir))) {
		if (($file != '.') && ($file != '..')) {
			if (is_dir($src . $file) ) {
				recurse_copy($src . $file . '/',$dst . $file . '/');
			} else {
				copy($src . $file,$dst . $file);
			}
		}
	}
	closedir($dir);
}
//---------------------------------------------------------------------------
?>
