/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#include "WX_Data.hpp"

WX_Data::WX_Data ()
{
	m_iRefCount = 0 ;
	m_pMutex = SDL_CreateMutex(); ;
}

WX_Data::~WX_Data ()
{
	SDL_DestroyMutex(m_pMutex);
}

int WX_Data::AddRef ()
{
	int ret = 0 ;
	if ( Lock () ) {
		ret = ++m_iRefCount ;
		Unlock () ;
	}
	return ret ;
}

int WX_Data::Release ()
{
	int ret = 0 ;
	if ( m_iRefCount == 0 ) {
		OnRelease () ;
	}else{
		if ( Lock () ) {
			ret = --m_iRefCount ;
			Unlock () ;
		}
	}
	return ret ;
}

bool WX_Data::Lock ()
{
	if ( SDL_LockMutex(m_pMutex) == 0 ) return true ;
	return false ;
}

bool WX_Data::Unlock ()
{
	if ( SDL_UnlockMutex(m_pMutex) == 0 ) return true ;
	return false ;
}

void* WX_Data::GetData ()
{
	return NULL ;
}

void WX_Data::OnRelease ()
{
}
