#include <stdio.h>
#include <SDL.h>

#ifdef _MSC_VER
#pragma comment(lib, "SDL.lib")
#pragma comment(lib, "SDLmain.lib")
#pragma comment(lib, "SDL_wx.lib")
#endif

#include "SDL_wx.hpp"

/*!
	\class SDLFrame
	\brief SDLで表示するサンプルフレーム
*/
class SDL_Frame : public wxFrame 
{
public :
	SDL_Frame (wxWindow* parent, wxWindowID id,const wxString& label) : wxFrame(parent, id, label, wxDefaultPosition,wxDefaultSize, wxDEFAULT_FRAME_STYLE )
	{
		/* ボタンの生成 */
		wxButton* btn = new wxButton(this,wxID_ANY,_("Click me!")) ;
		btn->Show () ;
	}

	void OnClicked (wxCommandEvent& evt)
	{
		WX_SendData((::Uint8)SDL_USEREVENT,0,NULL) ;
	}

private :
	DECLARE_EVENT_TABLE()
} ;

BEGIN_EVENT_TABLE(SDL_Frame, wxFrame)
EVT_BUTTON(wxID_ANY, SDL_Frame::OnClicked)
END_EVENT_TABLE()

/*!
	\class SDL_Object
	\brief wxWidgetsのwxAppクローン
*/
class SDL_Object : public WX_Object
{
public :
	bool OnInit ()
	{
		SDL_Frame* frame = new SDL_Frame(NULL, wxID_ANY, _T("Test")) ;
		frame->Show() ;
		return true ;
	}

	int OnExit ()
	{
		return 0 ;
	}

	void OnData (WX_Data* data)
	{
		printf ( "Get SDL event.\n" ) ;
	}
private :
} ;

/*!
	\class SDL_Data
*/
class SDL_Data : public WX_Data
{
public :
	SDL_Data () : WX_Data ()
	{
		m_pStrBuf = NULL ;
	}

	void SetData ( const char* data )
	{
		if ( Lock () ) {
			if ( data == NULL ) return ;
			if ( m_pStrBuf != NULL ) {
				delete[] m_pStrBuf ;
			}
			m_pStrBuf = new char [strlen(data)+1] ;
			strcpy ( m_pStrBuf, data ) ;
			Unlock () ;
		}
	}

	void OnRelease ()
	{
		delete[] m_pStrBuf ; 
	}
private :
	char* m_pStrBuf ;
} ;

int main ( int argc, char* argv[] )
{
	SDL_Init(SDL_INIT_EVERYTHING) ;
	
	/* wxWidgetsの初期化 */
	if ( WX_Init(argc, argv)!=0 ) {
		return 0 ;
	}

	SDL_SetVideoMode ( 800, 600, 32, SDL_SWSURFACE ) ;

	SDL_Event ev ;
	while ( WX_WasInit()==0 ) {
		SDL_PollEvent(&ev) ;
		SDL_Delay(10) ;
	}

	WX_RegisterObject (SDL_Object) ;
	WX_RegisterObject (SDL_Object) ;
	WX_RegisterObject (SDL_Object) ;

	/* SDL イベントループ */
	do {
		while ( SDL_PollEvent(&ev) ) {
			switch ( ev.type ) {
				/* ユーザーイベントに対応 */
				case SDL_USEREVENT :
					if ( ev.user.code == 0 ) printf ( "Get wx event.\n" ) ;
					break ;
				/* ユーザーイベントを送信 */
				case SDL_MOUSEBUTTONDOWN :
					WX_SendData(NULL) ;
					break ;
			}
		}
		SDL_Delay(10) ;
	} while (ev.type!=SDL_QUIT ) ;

	/* wxWidgetsの終了 */
	WX_Quit () ;

	SDL_Quit() ;

	return 0 ;
}
