/*
    SDL_cfg:  An configuration file parser based on the SDL library
    Copyright (C) 2001-2007 kr2

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#ifndef __XMLELEMENT_HPP__
#define __XMLELEMENT_HPP__

#include <libxml/xmlreader.h>
#include <libxml/tree.h>

#include <list>

class XMLDocument ;

class XMLElement {
	friend class XMLDocument ;
private :
	// コンストラクタの禁止（生成はXMLDocumentだけが行える)
	XMLElement ( xmlNode* cnode, XMLElement* prt ) ;

public :
	~XMLElement () ;

	// 要素削除
	void Delete () ;

	// 要素間関係
	XMLElement* GetElem ( const char* ename ) ;
	XMLElement* SetElem ( const char* ename ) ; // すでに存在する場合は、要素は作らず、その要素へのポインタを返す
	XMLElement* CreateElem ( const char* ename ) ; // すでに存在する場合は、新たに同名の要素を作成
	// イテレーターっぽく
	XMLElement* Next () ;
	XMLElement* Prev () ;
	// 名前検索機能付きイテレータ
	XMLElement* Next ( const char* name ) ;
	XMLElement* Prev ( const char* name ) ;

	XMLElement* GetChild();
	
	// 要素名
	const char* GetName () const ;
	void SetName ( const char* ename ) ;

	// プロパティ
	void SetPropStr ( const char* aname, const char* name ) ;
	const char* GetPropStr ( const char* aname ) ;
	void DeleteProp ( const char* propname ) ;

	// コンテンツ
	const char* GetContent () ;
	void SetContent ( const char* contentname ) ;


	// 要素が無いならtrue あるならfalseを返す
	bool Empty () { return node==NULL ; }

private :
	// 親
	XMLElement* parent ;
	// 自分自身
	xmlNode* node ;
	// Child List
	std::list<XMLElement*> clist ;
	// _
	
	xmlNode* SearchElement ( const char* ename ) ;
	static XMLElement* GetElementFromNode ( XMLElement* from, xmlNode* cnode ) ;
	xmlNode* SearchElement ( xmlNode* a_node, const char* ename, bool rev ) ;
	xmlAttr* SearchProp ( const char* aname ) ;
} ;



#endif // __XMLELEMENT_HPP__
 
