/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import java.util.regex.Pattern;
import org.basex.build.Builder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.TargetParser;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class DirParser
extends TargetParser {
    private static final int SKIPLOG = 10;
    private final StringList skipped = new StringList();
    private final Pattern filter;
    private final Prop prop;
    private final String root;
    private final boolean archives;
    private final boolean skip;
    private Parser parser;
    private int c;

    public DirParser(IO source, Prop pr) {
        this(source, "", pr);
    }

    public DirParser(IO source, String target, Prop pr) {
        super(source, target);
        this.prop = pr;
        String parent = source.dir();
        this.root = parent.endsWith("/") ? parent : String.valueOf(parent) + '/';
        this.skip = this.prop.is(Prop.SKIPCORRUPT);
        this.archives = this.prop.is(Prop.ADDARCHIVES);
        this.filter = !source.isDir() ? null : Pattern.compile(IOFile.regex(pr.get(Prop.CREATEFILTER)));
    }

    @Override
    public void parse(Builder build) throws IOException {
        build.meta.filesize = 0L;
        build.meta.original = this.src.path();
        this.parse(build, this.src);
    }

    /*
     * Unable to fully structure code
     */
    private void parse(Builder b, IO io) throws IOException {
        block16: {
            block15: {
                if (!io.isDir()) break block15;
                var6_3 = ((IOFile)io).children();
                var5_5 = var6_3.length;
                var4_7 = 0;
                while (var4_7 < var5_5) {
                    f = var6_3[var4_7];
                    this.parse(b, f);
                    ++var4_7;
                }
                break block16;
            }
            this.src = io;
            if (this.archives || !this.src.isArchive()) ** GOTO lbl58
            return;
lbl-1000:
            // 1 sources

            {
                block14: {
                    v0 = nm = Prop.WIN != false ? io.name().toLowerCase() : io.name();
                    if (this.filter != null && !this.filter.matcher(nm).matches()) continue;
                    b.meta.filesize += this.src.length();
                    targ = this.trg;
                    name = this.src.name();
                    path = this.src.path();
                    if (path.endsWith(String.valueOf('/') + name)) {
                        if ((path = path.substring(0, path.length() - name.length())).startsWith(this.root)) {
                            path = path.substring(this.root.length());
                        }
                        targ = (String.valueOf(targ) + path).replace("//", "/");
                    }
                    ok = true;
                    in = io;
                    if (this.skip) {
                        bi = null;
                        try {
                            try {
                                bi = io.buffer();
                                in = new IOContent(bi.readBytes());
                                in.name(io.name());
                                this.parser = Parser.fileParser(in, this.prop, targ);
                                MemBuilder.build("", this.parser, this.prop);
                            }
                            catch (IOException ex) {
                                Util.debug(ex.getMessage(), new Object[0]);
                                this.skipped.add(io.path());
                                ok = false;
                                if (bi != null) {
                                    bi.close();
                                }
                                break block14;
                            }
                        }
                        catch (Throwable var11_15) {
                            if (bi != null) {
                                bi.close();
                            }
                            throw var11_15;
                        }
                        if (bi != null) {
                            bi.close();
                        }
                    }
                }
                this.parser = Parser.fileParser(in, this.prop, targ);
                if (ok) {
                    this.parser.parse(b);
                }
                if (!Util.debug || (++this.c & 1023) != 0) continue;
                Util.err(";", new Object[0]);
lbl58:
                // 4 sources

                ** while (io.more())
            }
        }
    }

    @Override
    public String info() {
        TokenBuilder sb = new TokenBuilder();
        if (this.skipped.size() != 0) {
            sb.add(Text.SKIPCORRUPT).add(":").add(Text.NL);
            int s = this.skipped.size();
            int i = 0;
            while (i < s && i < 10) {
                sb.add("- ").add(this.skipped.get(i)).add(Text.NL);
                ++i;
            }
            if (s > 10) {
                sb.add("- ").addExt(Text.SKIPINFO, s - 10).add(Text.NL);
            }
        }
        return sb.toString();
    }

    @Override
    public String det() {
        return this.parser != null ? this.parser.detail() : "";
    }

    @Override
    public double prog() {
        return this.parser != null ? this.parser.progress() : 0.0;
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
    }
}

