/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.SingleParser;
import org.basex.build.file.CSVParser;
import org.basex.build.file.HTMLParser;
import org.basex.build.file.MAB2Parser;
import org.basex.build.file.TextParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.build.xml.XMLParser;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.util.Atts;

public abstract class Parser
extends Progress {
    private static final Parser DUMMY = new Parser(null){

        @Override
        public void parse(Builder build) {
        }
    };
    public IO src;
    protected final Atts atts = new Atts();

    protected Parser(String source) {
        this(source == null ? null : IO.get(source));
    }

    protected Parser(IO source) {
        this.src = source;
    }

    public abstract void parse(Builder var1) throws IOException;

    public void close() throws IOException {
    }

    public String info() {
        return "";
    }

    public static Parser emptyParser() {
        return DUMMY;
    }

    public static SingleParser xmlParser(IO source, Prop prop) throws IOException {
        return Parser.xmlParser(source, prop, "");
    }

    public static SingleParser xmlParser(IO source, Prop prop, String target) throws IOException {
        if (prop.is(Prop.INTPARSE)) {
            return new XMLParser(source, target, prop);
        }
        return new SAXWrapper(source, target, prop);
    }

    public static SingleParser fileParser(IO source, Prop prop, String target) throws IOException {
        String parser = prop.get(Prop.PARSER).toLowerCase();
        if (parser.equals("html")) {
            return new HTMLParser(source, target, prop);
        }
        if (parser.equals("text")) {
            return new TextParser(source, target, prop);
        }
        if (parser.equals("mab2")) {
            return new MAB2Parser(source, target, prop);
        }
        if (parser.equals("csv")) {
            return new CSVParser(source, target, prop);
        }
        return Parser.xmlParser(source, prop, target);
    }
}

