/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import java.util.Iterator;
import org.basex.core.AProp;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ParserProp
extends AProp {
    public static final Object[] SEPARATOR = new Object[]{"separator", "comma"};
    public static final Object[] HEADER = new Object[]{"header", false};
    public static final Object[] FORMAT = new Object[]{"format", "verbose"};
    public static final Object[] LINES = new Object[]{"lines", true};
    public static final Object[] FLAT = new Object[]{"flat", false};
    public static final Object[] ENCODING = new Object[]{"encoding", "UTF-8"};

    public ParserProp() {
        super(null);
    }

    public ParserProp(String s) throws IOException {
        this();
        String[] stringArray = s.trim().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ser = stringArray[n2];
            if (!ser.isEmpty()) {
                String[] sprop = ser.split("=", 2);
                String key = sprop[0].trim().toLowerCase();
                Object obj = this.get(key);
                if (obj == null) {
                    String in = key.toUpperCase();
                    String sim = this.similar(in);
                    throw new IOException(Util.info(sim != null ? Text.SETSIMILAR : Text.SETWHICH, in, sim));
                }
                if (obj instanceof Integer) {
                    int i;
                    int n3 = i = sprop.length < 2 ? 0 : Token.toInt(sprop[1]);
                    if (i == Integer.MIN_VALUE) {
                        throw new BaseXException(Text.SETVAL, key, sprop[1]);
                    }
                    this.set(key, (Object)i);
                } else if (obj instanceof Boolean) {
                    String val = sprop.length < 2 ? "true" : sprop[1];
                    this.set(key, (Object)Util.yes(val));
                } else {
                    this.set(key, (Object)(sprop.length < 2 ? "" : sprop[1]));
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator it = this.props.keySet().iterator();
        while (it.hasNext()) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            String s = (String)it.next();
            sb.append(String.valueOf(s) + '=' + this.props.get(s));
        }
        return sb.toString();
    }
}

