/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.BuildText;
import org.basex.build.SingleParser;
import org.basex.build.xml.XMLScanner;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public class XMLParser
extends SingleParser {
    private final XMLScanner scanner;
    private final TokenList tags = new TokenList();

    public XMLParser(IO source, String target, Prop pr) throws IOException {
        super(source, target);
        this.scanner = new XMLScanner(source, pr);
    }

    @Override
    public final void parse() throws IOException {
        this.scanner.more();
        while (true) {
            if (this.scanner.type == BuildText.Type.TEXT) {
                this.builder.text(this.scanner.token.finish());
            } else if (this.scanner.type == BuildText.Type.COMMENT) {
                this.builder.comment(this.scanner.token.finish());
            } else if (this.scanner.type == BuildText.Type.PI) {
                this.builder.pi(this.scanner.token.finish());
            } else {
                if (this.scanner.type == BuildText.Type.EOF) break;
                if (this.scanner.type != BuildText.Type.DTD) {
                    if (this.parseTag()) continue;
                    break;
                }
            }
            if (!this.scanner.more()) break;
        }
        this.scanner.close();
        this.builder.encoding(this.scanner.encoding);
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    private boolean parseTag() throws IOException {
        if (this.scanner.type == BuildText.Type.L_BR_CLOSE) {
            this.scanner.more();
            byte[] tag = this.consumeToken(BuildText.Type.TAGNAME);
            this.skipSpace();
            if (this.tags.empty()) {
                throw new BuildException("%: No text allowed after closed root tag.", this.det());
            }
            byte[] open = this.tags.pop();
            if (!Token.eq(open, tag)) {
                throw new BuildException("%: </%> found, </%> expected.", this.det(), tag, open);
            }
            this.builder.endElem();
            return this.consume(BuildText.Type.R_BR);
        }
        this.consume(BuildText.Type.L_BR);
        this.atts.reset();
        byte[] tag = this.consumeToken(BuildText.Type.TAGNAME);
        this.skipSpace();
        while (this.scanner.type != BuildText.Type.R_BR && this.scanner.type != BuildText.Type.CLOSE_R_BR) {
            byte[] attName = this.consumeToken(BuildText.Type.ATTNAME);
            this.skipSpace();
            this.consume(BuildText.Type.EQ);
            this.skipSpace();
            this.consume(BuildText.Type.QUOTE);
            byte[] attValue = Token.EMPTY;
            if (this.scanner.type == BuildText.Type.ATTVALUE) {
                attValue = this.scanner.token.finish();
                this.scanner.more();
            }
            this.consume(BuildText.Type.QUOTE);
            if (Token.startsWith(attName, Token.XMLNSC)) {
                this.builder.startNS(Token.ln(attName), attValue);
            } else if (Token.eq(attName, Token.XMLNS)) {
                this.builder.startNS(Token.EMPTY, attValue);
            } else {
                this.atts.add(attName, attValue);
            }
            if (this.scanner.type == BuildText.Type.R_BR || this.scanner.type == BuildText.Type.CLOSE_R_BR) continue;
            this.consume(BuildText.Type.WS);
        }
        if (this.scanner.type == BuildText.Type.CLOSE_R_BR) {
            this.builder.emptyElem(tag, this.atts);
            return this.scanner.more();
        }
        this.builder.startElem(tag, this.atts);
        this.tags.add(tag);
        return this.consume(BuildText.Type.R_BR);
    }

    private boolean consume(BuildText.Type t) throws IOException {
        if (this.scanner.type == t) {
            return this.scanner.more();
        }
        throw new BuildException("%: % expected, % found.", this.det(), t.string, this.scanner.type.string);
    }

    private byte[] consumeToken(BuildText.Type t) throws IOException {
        if (this.scanner.type == t) {
            byte[] tok = this.scanner.token.finish();
            this.scanner.more();
            return tok;
        }
        throw new BuildException("%: % expected, % found.", this.det(), t.string, this.scanner.type.string);
    }

    private void skipSpace() throws IOException {
        if (this.scanner.type == BuildText.Type.WS) {
            this.scanner.more();
        }
    }

    @Override
    public final String det() {
        return this.scanner.det();
    }

    @Override
    public final double prog() {
        return this.scanner.prog();
    }
}

