/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.Command;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateBackup;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateEvent;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropBackup;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.DropEvent;
import org.basex.core.cmd.DropIndex;
import org.basex.core.cmd.DropUser;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Export;
import org.basex.core.cmd.Find;
import org.basex.core.cmd.Flush;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Grant;
import org.basex.core.cmd.Help;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.InfoIndex;
import org.basex.core.cmd.InfoStorage;
import org.basex.core.cmd.Kill;
import org.basex.core.cmd.List;
import org.basex.core.cmd.ListDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Optimize;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.Password;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.RepoDelete;
import org.basex.core.cmd.RepoInstall;
import org.basex.core.cmd.RepoList;
import org.basex.core.cmd.Restore;
import org.basex.core.cmd.Retrieve;
import org.basex.core.cmd.Run;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.ShowBackups;
import org.basex.core.cmd.ShowDatabases;
import org.basex.core.cmd.ShowEvents;
import org.basex.core.cmd.ShowSessions;
import org.basex.core.cmd.ShowUsers;
import org.basex.core.cmd.Store;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.InputParser;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class CommandParser
extends InputParser {
    private final Context ctx;
    private boolean gui;

    public CommandParser(String in, Context c) {
        super(in);
        this.ctx = c;
    }

    public Command parseSingle() throws QueryException {
        Commands.Cmd cmd = this.consume(Commands.Cmd.class, null);
        Command command = this.parse(cmd, true);
        this.consumeWS();
        if (this.more()) {
            throw this.help(null, cmd);
        }
        return command;
    }

    public Command[] parse() throws QueryException {
        Commands.Cmd cmd;
        Command[] list = new Command[]{};
        do {
            cmd = this.consume(Commands.Cmd.class, null);
            list = Array.add(list, this.parse(cmd, false));
            this.consumeWS();
            if (this.more()) continue;
            return list;
        } while (this.consume(59));
        throw this.help(null, cmd);
    }

    public Command[] parse(boolean g) throws QueryException {
        this.gui = g;
        return this.parse();
    }

    private Command parse(Commands.Cmd cmd, boolean s) throws QueryException {
        switch (cmd) {
            case CREATE: {
                switch (this.consume(Commands.CmdCreate.class, cmd)) {
                    case BACKUP: {
                        return new CreateBackup(this.glob(cmd));
                    }
                    case DATABASE: 
                    case DB: {
                        return new CreateDB(this.name(cmd), s ? this.remaining(null) : this.string(null));
                    }
                    case INDEX: {
                        return new CreateIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new CreateUser(this.name(cmd), this.string(null));
                    }
                    case EVENT: {
                        return new CreateEvent(this.name(cmd));
                    }
                }
                break;
            }
            case COPY: {
                return new Copy(this.name(cmd), this.name(cmd));
            }
            case ALTER: {
                switch (this.consume(Commands.CmdAlter.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new AlterDB(this.name(cmd), this.name(cmd));
                    }
                    case USER: {
                        return new AlterUser(this.name(cmd), this.string(null));
                    }
                }
                break;
            }
            case OPEN: {
                return new Open(this.string(cmd));
            }
            case CHECK: {
                return new Check(this.string(cmd));
            }
            case ADD: {
                String arg = this.key("TO", null) ? this.string(cmd) : null;
                return new Add(arg, s ? this.remaining(cmd) : this.string(cmd));
            }
            case DELETE: {
                return new Delete(this.string(cmd));
            }
            case RENAME: {
                return new Rename(this.string(cmd), this.string(cmd));
            }
            case REPLACE: {
                return new Replace(this.string(cmd), this.string(cmd));
            }
            case INFO: {
                switch (this.consume(Commands.CmdInfo.class, cmd)) {
                    case NULL: {
                        return new Info();
                    }
                    case DATABASE: 
                    case DB: {
                        return new InfoDB();
                    }
                    case INDEX: {
                        return new InfoIndex((Object)this.consume(Commands.CmdIndexInfo.class, null));
                    }
                    case STORAGE: {
                        String arg2;
                        String arg1 = this.number(null);
                        String string = arg2 = arg1 != null ? this.number(null) : null;
                        if (arg1 == null) {
                            arg1 = this.xquery(null);
                        }
                        return new InfoStorage(arg1, arg2);
                    }
                }
                break;
            }
            case CLOSE: {
                return new Close();
            }
            case LIST: {
                String input = this.string(null);
                return input == null ? new List() : new ListDB(input);
            }
            case DROP: {
                switch (this.consume(Commands.CmdDrop.class, cmd)) {
                    case DATABASE: 
                    case DB: {
                        return new DropDB(this.glob(cmd));
                    }
                    case INDEX: {
                        return new DropIndex((Object)this.consume(Commands.CmdIndex.class, cmd));
                    }
                    case USER: {
                        return new DropUser(this.glob(cmd), this.key("ON", null) ? this.glob(cmd) : null);
                    }
                    case BACKUP: {
                        return new DropBackup(this.glob(cmd));
                    }
                    case EVENT: {
                        return new DropEvent(this.name(cmd));
                    }
                }
                break;
            }
            case OPTIMIZE: {
                switch (this.consume(Commands.CmdOptimize.class, cmd)) {
                    case NULL: {
                        return new Optimize();
                    }
                    case ALL: {
                        return new OptimizeAll();
                    }
                }
                break;
            }
            case EXPORT: {
                return new Export(this.string(cmd));
            }
            case XQUERY: {
                return new XQuery(this.xquery(cmd));
            }
            case RUN: {
                return new Run(this.string(cmd));
            }
            case FIND: {
                return new Find(this.string(cmd));
            }
            case CS: {
                return new Cs(this.xquery(cmd));
            }
            case GET: {
                return new Get(this.name(cmd));
            }
            case SET: {
                return new Set(this.name(cmd), (Object)this.string(null));
            }
            case PASSWORD: {
                return new Password(this.string(null));
            }
            case HELP: {
                String hc = this.name(null);
                String form = null;
                if (hc != null) {
                    if (hc.equalsIgnoreCase("wiki")) {
                        form = hc;
                        hc = null;
                    } else {
                        this.qp = this.qm;
                        hc = this.consume(Commands.Cmd.class, cmd).toString();
                        form = this.name(null);
                    }
                }
                return new Help(hc, form);
            }
            case EXIT: {
                return new Exit();
            }
            case FLUSH: {
                return new Flush();
            }
            case KILL: {
                return new Kill(this.glob(cmd));
            }
            case RESTORE: {
                return new Restore(this.name(cmd));
            }
            case SHOW: {
                switch (this.consume(Commands.CmdShow.class, cmd)) {
                    case DATABASES: {
                        return new ShowDatabases();
                    }
                    case SESSIONS: {
                        return new ShowSessions();
                    }
                    case USERS: {
                        return new ShowUsers(this.key("ON", null) ? this.name(cmd) : null);
                    }
                    case BACKUPS: {
                        return new ShowBackups();
                    }
                    case EVENTS: {
                        return new ShowEvents();
                    }
                }
                break;
            }
            case GRANT: {
                Commands.CmdPerm perm = this.consume(Commands.CmdPerm.class, cmd);
                if (perm == null) {
                    throw this.help(null, cmd);
                }
                String db = this.key("ON", null) ? this.glob(cmd) : null;
                this.key("TO", cmd);
                return new Grant((Object)perm, this.glob(cmd), db);
            }
            case REPO: {
                switch (this.consume(Commands.CmdRepo.class, cmd)) {
                    case INSTALL: {
                        return new RepoInstall(this.string(cmd), new InputInfo(this));
                    }
                    case DELETE: {
                        return new RepoDelete(this.string(cmd), new InputInfo(this));
                    }
                    case LIST: {
                        return new RepoList();
                    }
                }
                break;
            }
            case RETRIEVE: {
                return new Retrieve(this.string(cmd));
            }
            case STORE: {
                return new Store(this.string(cmd), this.string(cmd));
            }
        }
        throw Util.notexpected("command specified, but not implemented yet");
    }

    private String string(Commands.Cmd cmd) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        boolean q = false;
        while (this.more()) {
            char c = this.curr();
            if (!q && (c <= ' ' || c == ';')) break;
            if (c == '\"') {
                q ^= true;
            } else {
                sb.append(c);
            }
            this.consume();
        }
        return this.finish(cmd, sb);
    }

    private String remaining(Commands.Cmd cmd) throws QueryException {
        StringBuilder sb = new StringBuilder();
        this.consumeWS();
        while (this.more()) {
            sb.append(this.consume());
        }
        String arg = this.finish(cmd, sb);
        if (arg != null) {
            if (arg.startsWith("\"")) {
                arg = arg.substring(1);
            }
            if (arg.endsWith("\"")) {
                arg = arg.substring(0, arg.length() - 1);
            }
        }
        return arg;
    }

    private String xquery(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.more() && !this.curr(59)) {
            QueryParser p = new QueryParser(this.query, new QueryContext(this.ctx));
            p.qp = this.qp;
            p.parse(null);
            sb.append(this.query.substring(this.qp, p.qp));
            this.qp = p.qp;
        }
        return this.finish(cmd, sb);
    }

    private String name(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        while (Token.letterOrDigit(this.curr()) || this.curr(45)) {
            sb.append(this.consume());
        }
        return this.finish(cmd, !this.more() || this.curr(59) || Token.ws(this.curr()) ? sb : null);
    }

    private String glob(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        char c;
        while (Token.letterOrDigit(c = this.curr()) || c == '-' || c == '*' || c == '?' || c == ',') {
            sb.append(this.consume());
        }
        return this.finish(cmd, !this.more() || this.curr(59) || Token.ws(this.curr()) ? sb : null);
    }

    private boolean key(String key, Commands.Cmd cmd) throws QueryException {
        boolean ok;
        this.consumeWS();
        int p = this.qp;
        boolean bl = ok = !(!this.consume(key) && !this.consume(key.toLowerCase()) || !this.curr(0) && !Token.ws(this.curr()));
        if (!ok) {
            this.qp = p;
            if (cmd != null) {
                throw this.help(null, cmd);
            }
        }
        return ok;
    }

    private String finish(Commands.Cmd cmd, StringBuilder s) throws QueryException {
        if (s != null && s.length() != 0) {
            return s.toString();
        }
        if (cmd != null) {
            throw this.help(null, cmd);
        }
        return null;
    }

    private String number(Commands.Cmd cmd) throws QueryException {
        this.consumeWS();
        StringBuilder sb = new StringBuilder();
        if (this.curr() == '-') {
            sb.append(this.consume());
        }
        while (Token.digit(this.curr())) {
            sb.append(this.consume());
        }
        return this.finish(cmd, !this.more() || this.curr(59) || Token.ws(this.curr()) ? sb : null);
    }

    private void consumeWS() {
        while (this.qp < this.ql && this.query.charAt(this.qp) <= ' ') {
            ++this.qp;
        }
        this.qm = this.qp - 1;
    }

    private <E extends Enum<E>> E consume(Class<E> cmp, Commands.Cmd par) throws QueryException {
        String token = this.name(null);
        if (!this.gui || token == null || token.length() > 1) {
            try {
                String t = token == null ? "NULL" : token.toUpperCase();
                return Enum.valueOf(cmp, t);
            }
            catch (IllegalArgumentException t) {
                // empty catch block
            }
        }
        Enum<?>[] alt = this.list(cmp, token);
        if (token == null) {
            throw par == null ? this.error(this.list(alt), Text.CMDNO, new Object[0]) : this.help(this.list(alt), par);
        }
        byte[] name = Token.lc(Token.token(token));
        Levenshtein ls = new Levenshtein();
        Enum<?>[] enumArray = this.list(cmp, null);
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> s = enumArray[n2];
            byte[] sm = Token.lc(Token.token(s.name().toLowerCase()));
            if (ls.similar(name, sm, 0) && Commands.Cmd.class.isInstance(s)) {
                throw this.error(this.list(alt), Text.CMDSIMILAR, name, sm);
            }
            ++n2;
        }
        throw par == null ? this.error(this.list(alt), Text.CMDWHICH, token) : this.help(this.list(alt), par);
    }

    private QueryException help(StringList alt, Commands.Cmd cmd) {
        return this.error(alt, Text.PROCSYNTAX, cmd.help(true, false));
    }

    private <T extends Enum<T>> Enum<?>[] list(Class<T> en, String i) {
        Enum[] list = new Enum[]{};
        String t = i == null ? "" : i.toUpperCase();
        Enum[] enumArray = (Enum[])en.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            if (e.name().startsWith(t)) {
                int s = list.length;
                Enum[] tmp = new Enum[s + 1];
                System.arraycopy(list, 0, tmp, 0, s);
                tmp[s] = e;
                list = tmp;
            }
            ++n2;
        }
        return list;
    }

    private QueryException error(StringList comp, String m, Object ... e) {
        QueryException qe = new QueryException(this.input(), "", null, m, e);
        qe.complete(this, comp);
        return qe;
    }

    private StringList list(Enum<?>[] comp) {
        StringList list = new StringList();
        Enum<?>[] enumArray = comp;
        int n = comp.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> c = enumArray[n2];
            list.add(c.name().toLowerCase());
            ++n2;
        }
        return list;
    }
}

