/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Lang {
    private static final boolean DISALLOW = false;
    private static final boolean CHECK = true;
    private static final String SUFFIX = "lang";
    private static final HashMap<String, String> TETXTS = new HashMap();
    private static HashMap<String, Boolean> check;

    static {
        Lang.read(Util.language, true);
    }

    private Lang() {
    }

    private static synchronized void read(String lang, boolean chk) {
        block21: {
            BufferedReader br = null;
            try {
                try {
                    String path;
                    InputStream is;
                    if (chk) {
                        check = new HashMap();
                    }
                    if ((is = Lang.class.getResourceAsStream(path = "/lang/" + lang + "." + SUFFIX)) == null) {
                        Util.errln(String.valueOf(path) + " not found.", new Object[0]);
                    } else {
                        String line;
                        br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((line = br.readLine()) != null) {
                            int i = line.indexOf(61);
                            if (i == -1 || line.startsWith("#")) continue;
                            String key = line.substring(0, i);
                            String val = line.substring(i + 1);
                            if (val.contains("\\n")) {
                                val = val.replaceAll("\\\\n", Prop.NL);
                            }
                            if (Util.langkeys) {
                                val = "[" + key + ": " + val + "]";
                            }
                            if (TETXTS.get(key) == null) {
                                TETXTS.put(key, val);
                            } else if (chk) {
                                Util.errln("%.lang: '%' assigned twice", lang, key);
                            }
                            if (!chk) continue;
                            check.put(key, true);
                        }
                    }
                }
                catch (IOException ex) {
                    Util.errln(ex, new Object[0]);
                    if (br == null) break block21;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    static synchronized String lang(String key) {
        if (key == null) {
            if (check.size() != 0) {
                Iterator<String> it = check.keySet().iterator();
                while (it.hasNext()) {
                    Util.errln("%.lang: '%' not used", Util.language, it.next());
                }
            }
            return null;
        }
        String val = TETXTS.get(key);
        if (val == null) {
            if (TETXTS.size() != 0) {
                Util.errln("%.lang: '%' missing", Util.language, key);
            }
            return "[" + key + "]";
        }
        check.remove(key);
        return val;
    }

    static synchronized String lang(String key, Object ... e) {
        return Util.info(Lang.lang(key), e);
    }

    public static synchronized String[][] parse() {
        StringList langs = new StringList();
        StringList creds = new StringList();
        try {
            URL url = Lang.class.getResource("/lang");
            if (url.getProtocol().equals("jar")) {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                String pre = conn.getEntryName();
                JarFile jar = conn.getJarFile();
                Enumeration<JarEntry> je = jar.entries();
                while (je.hasMoreElements()) {
                    JarEntry entry = je.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(pre) || !name.endsWith(SUFFIX)) continue;
                    byte[] cont = new byte[(int)entry.getSize()];
                    new DataInputStream(jar.getInputStream(entry)).readFully(cont);
                    langs.add(name.replaceAll(".*/|.lang", ""));
                    creds.add(Lang.credits(cont));
                }
            } else {
                IOFile[] iOFileArray = new IOFile(url.getFile()).children();
                int n = iOFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IOFile f = iOFileArray[n2];
                    langs.add(f.name().replaceAll(".lang", ""));
                    creds.add(Lang.credits(((IO)f).read()));
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
        }
        return new String[][]{langs.toArray(), creds.toArray()};
    }

    private static synchronized String credits(byte[] cont) {
        StringTokenizer st = new StringTokenizer(Token.string(cont), "\n");
        st.nextToken();
        return st.nextToken().replaceAll("# ", "");
    }
}

