/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.Scanner;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.AlterUser;
import org.basex.core.cmd.CreateUser;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.Password;
import org.basex.query.QueryException;
import org.basex.server.Session;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public abstract class Main {
    public final Context context;
    protected OutputStream out = System.out;
    protected boolean console;
    protected Session session;
    protected boolean verbose;

    protected Main(String[] args) throws IOException {
        this(args, null);
    }

    protected Main(String[] args, Context ctx) throws IOException {
        this.context = ctx != null ? ctx : new Context();
        this.parseArguments(args);
        this.verbose |= this.console;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void run() {
                Main.this.context.close();
            }
        });
    }

    protected final void console() {
        while (this.console) {
            Util.out("> ", new Object[0]);
            for (String in : this.inputs()) {
                if (in.isEmpty()) continue;
                try {
                    if (this.execute(in)) continue;
                    Util.outln(Text.CLIENTBYE[new Random().nextInt(4)], new Object[0]);
                    return;
                }
                catch (IOException ex) {
                    Util.errln(ex, new Object[0]);
                }
            }
        }
    }

    protected void quit() throws IOException {
        this.execute(new Exit(), true);
        if (this.out == System.out || this.out == System.err) {
            this.out.flush();
        } else {
            this.out.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean execute(String in) throws IOException {
        try {
            Command[] commandArray = new CommandParser(in, this.context).parse();
            int n = commandArray.length;
            int n2 = 0;
            while (true) {
                int i;
                if (n2 >= n) {
                    return true;
                }
                Command cmd = commandArray[n2];
                if (cmd instanceof Exit) {
                    return false;
                }
                int n3 = cmd instanceof Password && cmd.args[0] == null ? 0 : (i = (cmd instanceof CreateUser || cmd instanceof AlterUser) && cmd.args[1] == null ? 1 : -1);
                if (i != -1) {
                    Util.out(String.valueOf(Text.SERVERPW) + ": ", new Object[0]);
                    cmd.args[i] = Token.md5(Util.password());
                }
                this.execute(cmd, this.verbose);
                ++n2;
            }
        }
        catch (QueryException ex) {
            Util.debug(ex);
            throw new BaseXException(ex);
        }
    }

    protected final void execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        ss.execute(cmd);
        if (info) {
            Util.out(ss.info(), new Object[0]);
        }
    }

    protected final StringList inputs() {
        StringList sl = new StringList();
        Scanner scan = new Scanner(System.in).useDelimiter("\\z");
        if (scan.hasNext()) {
            Scanner lines = new Scanner(scan.next());
            while (lines.hasNextLine()) {
                sl.add(lines.nextLine());
            }
        }
        if (sl.size() == 0) {
            sl.add(Commands.Cmd.EXIT.toString());
        }
        return sl;
    }

    protected abstract Session session() throws IOException;

    protected abstract void parseArguments(String[] var1) throws IOException;
}

