/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexToken;
import org.basex.index.ft.FTBuilder;
import org.basex.index.path.PathBuilder;
import org.basex.index.value.ValueBuilder;
import org.basex.util.Util;

public abstract class ACreate
extends Command {
    private Builder builder;
    private boolean closing;

    protected ACreate(String ... arg) {
        this(4, arg);
        this.closing = true;
    }

    protected ACreate(int flags, String ... arg) {
        super(flags, arg);
    }

    @Override
    public boolean newData(Context ctx) {
        if (this.closing) {
            new Close().run(ctx);
        }
        return this.closing;
    }

    @Override
    public final boolean supportsProg() {
        return true;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    protected final boolean build(Parser parser, String db) {
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        new Close().run(this.context);
        try {
            if (this.context.pinned(db)) {
                return this.error(Text.DBLOCKED, db);
            }
            boolean mem = this.prop.is(Prop.MAINMEM);
            this.builder = mem ? new MemBuilder(db, parser, this.prop) : new DiskBuilder(db, parser, this.context);
            Data data = this.progress(this.builder).build();
            if (mem) {
                this.context.openDB(data);
                this.context.pin(data);
            } else {
                data.close();
                Open open = new Open(db);
                if (!open.run(this.context)) {
                    return this.error(open.info(), new Object[0]);
                }
                data = this.context.data();
                if (this.prop.is(Prop.TEXTINDEX)) {
                    this.index(IndexToken.IndexType.TEXT, data);
                }
                if (this.prop.is(Prop.ATTRINDEX)) {
                    this.index(IndexToken.IndexType.ATTRIBUTE, data);
                }
                if (this.prop.is(Prop.FTINDEX)) {
                    this.index(IndexToken.IndexType.FULLTEXT, data);
                }
                data.flush();
            }
            return this.info(String.valueOf(parser.info()) + Text.DBCREATED, db, this.perf);
        }
        catch (ProgressException ex) {
            throw ex;
        }
        catch (IOException ex) {
            Util.debug(ex);
            this.abort();
            String msg = ex.getMessage();
            return this.error(msg != null && msg.length() != 0 ? msg : Util.info(Text.PARSEERR, parser.src), new Object[0]);
        }
        catch (Exception ex) {
            Util.debug(ex);
            this.abort();
            return this.error(Util.info(Text.PARSEERR, parser.src), new Object[0]);
        }
    }

    protected final void index(IndexToken.IndexType type, Data data) throws IOException {
        ACreate.index(type, data, this);
    }

    protected static void index(IndexToken.IndexType type, Data data, ACreate cmd) throws IOException {
        if (data instanceof MemData) {
            return;
        }
        IndexBuilder ib = null;
        switch (type) {
            case TEXT: {
                ib = new ValueBuilder(data, true);
                break;
            }
            case ATTRIBUTE: {
                ib = new ValueBuilder(data, false);
                break;
            }
            case FULLTEXT: {
                ib = FTBuilder.get(data);
                break;
            }
            case PATH: {
                ib = new PathBuilder(data);
                break;
            }
            default: {
                throw Util.notexpected(new Object[0]);
            }
        }
        data.closeIndex(type);
        data.setIndex(type, (cmd == null ? ib : cmd.progress(ib)).build());
    }
}

