/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Context;
import org.basex.core.ProgressException;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.NullOutput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.DOTSerializer;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.item.Item;
import org.basex.query.iter.Iter;
import org.basex.util.Performance;
import org.basex.util.Util;

abstract class AQuery
extends Command {
    protected Result result;
    private QueryProcessor qp;
    private long pars;
    private long comp;
    private long eval;
    private long prnt;

    protected AQuery(int flags, String ... arg) {
        super(flags, arg);
    }

    protected final boolean query(String query) {
        int runs = Math.max(1, this.prop.num(Prop.RUNS));
        String err = null;
        String inf = "";
        try {
            boolean serial = this.prop.is(Prop.SERIALIZE);
            long hits = 0L;
            int updates = 0;
            int i = 0;
            while (i < runs) {
                Serializer ser;
                PrintOutput po;
                Performance per = new Performance();
                this.qp = this.progress(new QueryProcessor(query, this.context));
                this.qp.parse();
                this.pars += per.getTime();
                if (i == 0) {
                    this.plan(false);
                }
                this.qp.compile();
                this.comp += per.getTime();
                if (i == 0) {
                    this.plan(true);
                }
                PrintOutput printOutput = po = i == 0 && serial ? this.out : new NullOutput();
                if (this.prop.is(Prop.CACHEQUERY)) {
                    this.result = this.qp.execute();
                    this.eval += per.getTime();
                    ser = this.qp.getSerializer(po);
                    this.result.serialize(ser);
                    hits = this.result.size();
                } else {
                    Iter ir = this.qp.iter();
                    this.eval += per.getTime();
                    hits = 0L;
                    Item it = ir.next();
                    ser = this.qp.getSerializer(po);
                    while (it != null) {
                        this.checkStop();
                        ser.openResult();
                        it.serialize(ser);
                        ser.closeResult();
                        it = ir.next();
                        ++hits;
                    }
                }
                updates = this.qp.updates();
                ser.close();
                this.qp.close();
                this.prnt += per.getTime();
                ++i;
            }
            if (this.prop.is(Prop.QUERYINFO)) {
                this.evalInfo(query, hits, updates, runs);
            }
            this.out.flush();
            return this.info(String.valueOf(Text.NL) + Text.QUERYEXEC, this.perf.getTimer(runs));
        }
        catch (QueryException ex) {
            Util.debug(ex);
            err = ex.getMessage();
        }
        catch (IOException ex) {
            Util.debug(ex);
            err = ex.getMessage();
        }
        catch (ProgressException ex) {
            err = "Interrupted.";
            inf = this.info();
        }
        catch (RuntimeException ex) {
            Util.debug(this.qp.info(), new Object[0]);
            throw ex;
        }
        if (this.qp != null) {
            try {
                this.qp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.error(err, new Object[0]);
        if (Util.debug || err.startsWith("Interrupted.")) {
            this.info(Text.NL, new Object[0]);
            this.info(String.valueOf(Text.QUERYSTRING) + query, new Object[0]);
            this.info(this.qp.info(), new Object[0]);
            this.info(inf, new Object[0]);
        }
        return false;
    }

    protected final boolean updating(Context ctx, String qu) {
        return QueryProcessor.updating(ctx, qu);
    }

    protected final void queryNodes() {
        try {
            this.result = new QueryProcessor(this.args[0], this.context).queryNodes();
        }
        catch (QueryException ex) {
            Util.debug(ex);
            this.error(ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public final Result result() {
        return this.result;
    }

    private void evalInfo(String query, long hits, long updates, int runs) {
        long total = this.pars + this.comp + this.eval + this.prnt;
        this.info(Text.NL, new Object[0]);
        this.info(String.valueOf(Text.QUERYSTRING) + query, new Object[0]);
        this.info(this.qp.info(), new Object[0]);
        this.info(String.valueOf(Text.QUERYPARSE) + Performance.getTimer(this.pars, runs), new Object[0]);
        this.info(String.valueOf(Text.QUERYCOMPILE) + Performance.getTimer(this.comp, runs), new Object[0]);
        this.info(String.valueOf(Text.QUERYEVALUATE) + Performance.getTimer(this.eval, runs), new Object[0]);
        this.info(String.valueOf(Text.QUERYPRINT) + Performance.getTimer(this.prnt, runs), new Object[0]);
        this.info(String.valueOf(Text.QUERYTOTAL) + Performance.getTimer(total, runs) + Text.NL, new Object[0]);
        this.info(String.valueOf(Text.QUERYHITS) + hits + " " + (hits == 1L ? "Item" : "Items"), new Object[0]);
        this.info(String.valueOf(Text.QUERYUPDATED) + updates + " " + (updates == 1L ? "Item" : "Items"), new Object[0]);
        this.info(String.valueOf(Text.QUERYPRINTED) + Performance.format(this.out.size()), new Object[0]);
    }

    private void plan(boolean c) {
        if (c != this.prop.is(Prop.COMPPLAN)) {
            return;
        }
        try {
            ArrayOutput ao;
            if (this.prop.is(Prop.DOTPLAN)) {
                ao = new ArrayOutput();
                DOTSerializer d = new DOTSerializer(ao, this.prop.is(Prop.DOTCOMPACT));
                this.qp.plan(d);
                d.close();
                String path = this.context.prop.get(Prop.QUERYPATH);
                String dot = path.isEmpty() ? "plan.dot" : new IOFile(path).name().replaceAll("\\..*?$", ".dot");
                new IOFile(dot).write(ao.toArray());
                if (this.prop.is(Prop.DOTDISPLAY)) {
                    new ProcessBuilder(this.prop.get(Prop.DOTTY), dot).start();
                }
            }
            if (this.prop.is(Prop.XMLPLAN)) {
                ao = new ArrayOutput();
                this.qp.plan(Serializer.get(ao));
                this.info(String.valueOf(Text.NL) + Text.QUERYPLAN, new Object[0]);
                this.info(ao.toString(), new Object[0]);
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init().xquery(0);
    }

    @Override
    public boolean stoppable() {
        return true;
    }
}

