/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.TargetParser;
import org.basex.build.xml.SAXWrapper;
import org.basex.core.CommandBuilder;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.DropDB;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class Add
extends ACreate {
    private Builder build;

    public Add(String path) {
        this(path, (String)null);
    }

    public Add(String path, String input) {
        super(514, path == null ? "" : path, input);
    }

    @Override
    protected boolean run() {
        TargetParser parser;
        boolean create = this.context.user.perm(4);
        String path = this.args[0];
        String name = MetaData.normPath(path);
        if (name == null || name.endsWith(".")) {
            return this.error(Text.NAMEINVALID, path);
        }
        IO io = null;
        if (this.in == null) {
            io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.FILEWHICH, create ? io : this.args[1]);
            }
            if (!name.endsWith("/") && (io.isDir() || io.isArchive())) {
                name = String.valueOf(name) + '/';
            }
        }
        String target = "";
        int s = name.lastIndexOf(47);
        if (s != -1) {
            target = name.substring(0, s);
            name = name.substring(s + 1);
        }
        if (io != null) {
            if (!name.isEmpty()) {
                io.name(name);
            } else if (!(io instanceof IOContent)) {
                name = io.name();
            }
            parser = new DirParser(io, target, this.prop);
        } else {
            parser = new SAXWrapper(new SAXSource(this.in), name, target, this.context.prop);
        }
        if (name.isEmpty()) {
            return this.error(Text.NAMEINVALID, name);
        }
        long fl = parser.src.length();
        boolean large = false;
        Runtime rt = Runtime.getRuntime();
        if (fl > rt.freeMemory() / 3L) {
            Performance.gc(2);
            large = fl > rt.freeMemory() / 3L;
        }
        Data data = this.context.data();
        String dbname = large ? this.context.mprop.random(data.meta.name) : name;
        this.build = large ? new DiskBuilder(dbname, (Parser)parser, this.context) : new MemBuilder(dbname, parser, this.context.prop);
        Data tmp = null;
        try {
            tmp = this.build.build();
            if (tmp.meta.size > 1) {
                data.insert(data.meta.size, -1, tmp);
                this.context.update();
                data.flush();
            }
            boolean bl = this.info(String.valueOf(parser.info()) + Text.PATHADDED, name, this.perf);
            return bl;
        }
        catch (IOException ex) {
            Util.debug(ex);
            boolean bl = this.error(Util.message(ex), new Object[0]);
            return bl;
        }
        finally {
            try {
                this.build.close();
            }
            catch (IOException iOException) {}
            if (tmp != null) {
                try {
                    tmp.close();
                }
                catch (IOException iOException) {}
            }
            if (large) {
                DropDB.drop(dbname, this.context.mprop);
            }
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init().arg("TO", 0).arg(1);
    }

    @Override
    protected String tit() {
        return Text.BUTTONADD;
    }

    @Override
    protected double prog() {
        return this.build != null ? this.build.prog() : 0.0;
    }
}

