/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.sax.SAXSource;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.SAXWrapper;
import org.basex.core.BaseXException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.index.IndexToken;
import org.basex.index.ft.FTBuilder;
import org.basex.index.value.ValueBuilder;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.BufferInput;
import org.basex.io.in.LookupInput;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class CreateDB
extends ACreate {
    public CreateDB(String name) {
        this(name, (String)null);
    }

    public CreateDB(String name, String input) {
        super(name, input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean run() {
        String name = this.args[0];
        Parser parser = Parser.emptyParser();
        if (this.args.length < 1 || this.args[1] == null) {
            if (this.in == null || this.in.getByteStream() == null) return this.build(parser, name);
            InputStream is = this.in.getByteStream();
            if (!(is instanceof BufferedInputStream) && !(is instanceof BufferInput)) {
                is = new BufferedInputStream(is);
            }
            try {
                LookupInput li = new LookupInput(is);
                if (li.lookup() == -1) return this.build(parser, name);
                parser = new SAXWrapper(new SAXSource(new InputSource(li)), String.valueOf(name) + ".xml", "", this.context.prop);
                return this.build(parser, name);
            }
            catch (IOException ex) {
                Util.debug(ex);
                return this.error(Util.message(ex), new Object[0]);
            }
        } else {
            IO io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.FILEWHICH, io);
            }
            if (io instanceof IOContent) {
                io.name(String.valueOf(name) + ".xml");
            }
            parser = new DirParser(io, this.prop);
        }
        return this.build(parser, name);
    }

    public static synchronized Data create(String name, Parser parser, Context ctx) throws IOException {
        if (!ctx.user.perm(4)) {
            throw new BaseXException(Text.PERMNO, new Object[]{Commands.CmdPerm.CREATE});
        }
        Prop prop = ctx.prop;
        if (prop.is(Prop.MAINMEM)) {
            return MemBuilder.build(name, parser, ctx.prop);
        }
        if (ctx.pinned(name)) {
            throw new BaseXException(Text.DBLOCKED, name);
        }
        DiskBuilder builder = new DiskBuilder(name, parser, ctx);
        try {
            Data data = ((Builder)builder).build();
            if (prop.is(Prop.TEXTINDEX)) {
                data.setIndex(IndexToken.IndexType.TEXT, new ValueBuilder(data, true).build());
            }
            if (prop.is(Prop.ATTRINDEX)) {
                data.setIndex(IndexToken.IndexType.ATTRIBUTE, new ValueBuilder(data, false).build());
            }
            if (prop.is(Prop.FTINDEX)) {
                data.setIndex(IndexToken.IndexType.FULLTEXT, FTBuilder.get(data).build());
            }
            data.close();
        }
        finally {
            try {
                ((Builder)builder).close();
            }
            catch (IOException exx) {
                Util.debug(exx);
            }
        }
        return Open.open(name, ctx);
    }

    public static synchronized MemData mainMem(Parser parser, Context ctx) throws IOException {
        if (ctx.user.perm(4)) {
            return MemBuilder.build(parser, ctx.prop);
        }
        throw new BaseXException(Text.PERMNO, new Object[]{Commands.CmdPerm.CREATE});
    }

    public static synchronized MemData mainMem(IO source, Context ctx) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException(Util.info(Text.FILEWHICH, source));
        }
        return CreateDB.mainMem(new DirParser(source, ctx.prop), ctx);
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.DB)).args();
    }
}

