/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.MainProp;
import org.basex.core.Text;
import org.basex.data.MetaData;

public final class DropDB
extends Command {
    public DropDB(String name) {
        super(4, name);
    }

    @Override
    protected boolean run() {
        if (!MetaData.validName(this.args[0], true)) {
            return this.error(Text.NAMEINVALID, this.args[0]);
        }
        String[] dbs = this.databases(this.args[0]);
        if (dbs.length == 0) {
            return this.info(Text.DBNOTDROPPED, this.args[0]);
        }
        boolean ok = true;
        String[] stringArray = dbs;
        int n = dbs.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            DropDB.close(this.context, db);
            if (this.context.pinned(db)) {
                this.info(Text.DBLOCKED, db);
                ok = false;
            } else if (!DropDB.drop(db, this.mprop)) {
                this.info(Text.DBDROPERROR, db);
                ok = false;
            } else {
                this.info(Text.DBDROPPED, db);
            }
            ++n2;
        }
        return ok;
    }

    public static synchronized boolean drop(String db, MainProp mprop) {
        return DropDB.drop(mprop.dbpath(db), null);
    }

    public static synchronized boolean drop(File path, String pat) {
        boolean ok = path.exists();
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File sub = fileArray[n2];
                ok &= sub.isDirectory() ? DropDB.drop(sub, pat) : pat != null && !sub.getName().matches(pat) || sub.delete();
                ++n2;
            }
        }
        return (pat != null || path.delete()) && ok;
    }

    @Override
    public boolean newData(Context ctx) {
        return DropDB.close(ctx, this.args[0]);
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.DB)).args();
    }
}

