/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Copy;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Export
extends Command {
    public Export(String path) {
        super(516, path);
    }

    @Override
    protected boolean run() {
        try {
            Data data = this.context.data();
            Export.export(data, this.args[0]);
            return this.info(Text.DBEXPORTED, data.meta.name, this.perf);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    public static void export(Data data, String target) throws IOException {
        String exp = data.meta.prop.get(Prop.EXPORTER);
        SerializerProp sp = new SerializerProp(exp);
        IOFile root = new IOFile(target);
        root.md();
        HashSet<String> exported = new HashSet<String>();
        IntList il = data.docs();
        int i = 0;
        int is = il.size();
        while (i < is) {
            int pre = il.get(i);
            IOFile file = root.merge(Token.string(data.text(pre, true)));
            IOFile dir = new IOFile(file.dir());
            if (!dir.exists()) {
                dir.md();
            }
            PrintOutput po = new PrintOutput(Export.unique(exported, file.path()));
            Serializer ser = Serializer.get(po, sp);
            ser.node(data, pre);
            ser.close();
            po.close();
            ++i;
        }
        IOFile bin = data.meta.binaries();
        for (String s : bin.descendants()) {
            String u = Export.unique(exported, new IOFile(root.path(), s).path());
            Copy.copy(new File(bin.file(), s), new File(u));
        }
    }

    private static String unique(HashSet<String> exp, String fp) {
        int c = 1;
        String path = fp;
        while (exp.contains(path)) {
            String string = path = fp.indexOf(46) == -1 ? String.valueOf(fp) + '(' + ++c + ')' : fp.replaceAll("(.*)\\.(.*)", "$1(" + ++c + ").$2");
        }
        exp.add(path);
        return path;
    }
}

