/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.MimeTypes;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class ListDB
extends Command {
    public ListDB(String path) {
        super(256, path);
    }

    @Override
    protected boolean run() throws IOException {
        String path;
        String str = this.args[0];
        int s = str.indexOf(47);
        String db = s == -1 ? str : str.substring(0, s);
        String string = path = s == -1 ? "" : str.substring(s + 1);
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        Table table = new Table();
        table.description = Text.INFONRES;
        table.header.add(Text.INFOPATH);
        table.header.add(Text.INFOTYPE);
        table.header.add("Content-Type");
        table.header.add(Text.INFODBSIZE);
        try {
            TokenList tl;
            Data data = Open.open(db, this.context);
            IntList il = data.docs(path);
            int i = 0;
            int ds = il.size();
            while (i < ds) {
                int pre = il.get(i);
                tl = new TokenList(3);
                tl.add(data.text(pre, true));
                tl.add("xml");
                tl.add("application/xml");
                tl.add(data.size(pre, 0));
                table.contents.add(tl);
                ++i;
            }
            for (byte[] fl : data.files(path)) {
                String file = Token.string(fl);
                tl = new TokenList(3);
                tl.add(fl);
                tl.add("raw");
                tl.add(MimeTypes.get(file));
                tl.add(data.meta.binary(file).length());
                table.contents.add(tl);
            }
            Close.close(data, this.context);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return msg.isEmpty() ? this.error(Text.DBOPENERR, db) : this.error(msg, new Object[0]);
        }
        table.sort();
        this.out.println(table.finish());
        return true;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init(Commands.Cmd.LIST.toString()).args();
    }
}

