/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.DiskBuilder;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.DiskData;
import org.basex.data.MetaData;
import org.basex.index.IndexToken;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.serial.BuilderSerializer;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class OptimizeAll
extends ACreate {
    int pre;
    private int size;

    public OptimizeAll() {
        super(514, new String[0]);
    }

    @Override
    protected boolean run() {
        try {
            Data data = this.context.data();
            OptimizeAll.optimizeAll(data, this.context, this);
            Open open = new Open(data.meta.name);
            return open.run(this.context) ? this.info(Text.DBOPTIMIZED, data.meta.name, this.perf) : this.error(open.info(), new Object[0]);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public double prog() {
        return (double)this.pre / (double)this.size;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public String det() {
        return Text.INFOSTATS;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.OPTIMIZE) + " " + "ALL");
    }

    public static void optimizeAll(Data data, Context ctx, OptimizeAll cmd) throws IOException {
        if (!(data instanceof DiskData)) {
            throw new BaseXException(Text.PROCMM, new Object[0]);
        }
        DiskData old = (DiskData)data;
        MetaData m = old.meta;
        if (cmd != null) {
            cmd.size = m.size;
        }
        if (ctx.datas.pins(m.name) > 1) {
            throw new BaseXException(Text.DBLOCKED, m.name);
        }
        String tname = ctx.mprop.random(m.name);
        DiskBuilder builder = new DiskBuilder(tname, (Parser)new DBParser(old, cmd), ctx);
        try {
            DiskData d = builder.build();
            if (m.textindex || ctx.prop.is(Prop.TEXTINDEX)) {
                OptimizeAll.index(IndexToken.IndexType.TEXT, d, cmd);
            }
            if (m.attrindex || ctx.prop.is(Prop.ATTRINDEX)) {
                OptimizeAll.index(IndexToken.IndexType.ATTRIBUTE, d, cmd);
            }
            if (m.ftindex || ctx.prop.is(Prop.FTINDEX)) {
                OptimizeAll.index(IndexToken.IndexType.FULLTEXT, d, cmd);
            }
            d.meta.filesize = m.filesize;
            d.meta.users = m.users;
            d.meta.dirty = true;
            IOFile bin = data.meta.binaries();
            if (bin.exists()) {
                bin.rename(d.meta.binaries());
            }
            d.close();
        }
        finally {
            try {
                builder.close();
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        Close.close(data, ctx);
        if (!DropDB.drop(m.name, ctx.mprop)) {
            throw new BaseXException(Text.DBDROPERROR, m.name);
        }
        if (!AlterDB.alter(tname, m.name, ctx.mprop)) {
            throw new BaseXException(Text.DBNOTALTERED, tname);
        }
    }

    private static final class DBParser
    extends Parser {
        private final DiskData data;
        final OptimizeAll cmd;

        protected DBParser(DiskData d, OptimizeAll c) {
            super(d.meta.original.isEmpty() ? null : IO.get(d.meta.original));
            this.data = d;
            this.cmd = c;
        }

        @Override
        public void parse(Builder build) throws IOException {
            BuilderSerializer ser = new BuilderSerializer(build){

                @Override
                protected void startOpen(byte[] t) throws IOException {
                    super.startOpen(t);
                    if (DBParser.this.cmd != null) {
                        ++DBParser.this.cmd.pre;
                    }
                }

                @Override
                protected void openDoc(byte[] name) throws IOException {
                    super.openDoc(name);
                    if (DBParser.this.cmd != null) {
                        ++DBParser.this.cmd.pre;
                    }
                }
            };
            IntList il = this.data.docs();
            int i = 0;
            int is = il.size();
            while (i < is) {
                ser.node(this.data, il.get(i));
                ++i;
            }
        }
    }
}

