/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Store;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOFile;

public final class Replace
extends ACreate {
    public Replace(String path, String input) {
        super(514, path, input);
    }

    public Replace(String path) {
        super(514, path);
    }

    @Override
    protected boolean run() {
        String path;
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.FILEWHICH, io);
            }
            this.in = io.inputSource();
        }
        if ((path = MetaData.normPath(this.args[0])) == null || path.isEmpty()) {
            return this.error(Text.DIRERR, this.args[0]);
        }
        Data data = this.context.data();
        int pre = data.doc(path);
        if (pre != -1 && data.docs(path).size() != 1) {
            return this.error(Text.DIRERR, path);
        }
        IOFile file = data.meta.binary(path);
        if (file != null && file.exists()) {
            Store store = new Store(path);
            store.setInput(this.in);
            if (!store.run(this.context)) {
                return this.error(store.info(), new Object[0]);
            }
        } else {
            Add add = new Add(path);
            add.setInput(this.in);
            if (!add.run(this.context)) {
                return this.error(add.info(), new Object[0]);
            }
            if (pre != -1) {
                data.delete(pre);
            }
            data.flush();
        }
        return this.info(Text.PATHREPLACED, 1, this.perf);
    }
}

