/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Open;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Restore
extends Command {
    private static final String PATTERN = "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    private boolean closed;

    public Restore(String arg) {
        super(4, arg);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        if (!MetaData.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        File file = this.mprop.dbpath(String.valueOf(db) + ".zip");
        if (!file.exists()) {
            StringList list = Restore.list(db, this.context);
            if (list.size() != 0) {
                file = new File(list.get(0));
            }
        } else {
            db = db.replace("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$", "");
        }
        if (!file.exists()) {
            return this.error(Text.DBBACKNF, db);
        }
        if (!this.closed) {
            this.closed = Restore.close(this.context, db);
        }
        if (this.context.pinned(db)) {
            return this.error(Text.DBLOCKED, db);
        }
        return this.restore(file) && (!this.closed || new Open(db).run(this.context)) ? this.info(Text.DBRESTORE, file.getName(), this.perf) : this.error(Text.DBNORESTORE, db);
    }

    private boolean restore(File file) {
        try {
            this.progress(new Zip(new IOFile(file))).unzip(this.mprop.dbpath());
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    public static StringList list(String db, Context ctx) {
        StringList list = new StringList();
        IOFile dir = ctx.mprop.dbpath();
        if (!dir.exists()) {
            return list;
        }
        IOFile[] iOFileArray = dir.children();
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            if (f.name().matches(String.valueOf(db) + PATTERN + ".zip")) {
                list.add(f.path());
            }
            ++n2;
        }
        list.sort(false, false);
        return list;
    }

    @Override
    protected String tit() {
        return Text.BUTTONRESTORE;
    }

    @Override
    public boolean newData(Context ctx) {
        this.closed = Restore.close(ctx, this.args[0]);
        return this.closed;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }
}

