/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.Index;
import org.basex.index.IndexToken;
import org.basex.index.Names;
import org.basex.index.ft.FTIndex;
import org.basex.index.path.PathSummary;
import org.basex.index.value.DiskValues;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.io.random.TableDiskAccess;
import org.basex.util.Compress;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.Util;

public final class DiskData
extends Data {
    private final Compress comp = new Compress();
    private DataAccess texts;
    private DataAccess values;

    public DiskData(String db, Context ctx) throws IOException {
        this.meta = new MetaData(db, ctx);
        int cats = ctx.prop.num(Prop.CATEGORIES);
        DataInput in = new DataInput(this.meta.dbfile("inf"));
        try {
            String k;
            this.meta.read(in);
            while (!(k = Token.string(in.readToken())).isEmpty()) {
                if (k.equals("TAGS")) {
                    this.tagindex = new Names(in, cats);
                    continue;
                }
                if (k.equals("ATTS")) {
                    this.atnindex = new Names(in, cats);
                    continue;
                }
                if (k.equals("PATH")) {
                    this.pthindex = new PathSummary(this, in);
                    continue;
                }
                if (k.equals("NS")) {
                    this.ns = new Namespaces(in);
                    continue;
                }
                if (!k.equals("DOCS")) continue;
                this.docindex.read(in);
            }
            this.init();
            if (this.meta.textindex) {
                this.txtindex = new DiskValues(this, true);
            }
            if (this.meta.attrindex) {
                this.atvindex = new DiskValues(this, false);
            }
            if (this.meta.ftindex) {
                this.ftxindex = FTIndex.get(this, this.meta.wildcards);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public DiskData(MetaData md, Names nm, Names at, PathSummary ps, Namespaces n) throws IOException {
        this.meta = md;
        this.tagindex = nm;
        this.atnindex = at;
        this.pthindex = ps;
        this.pthindex.finish(this);
        this.ns = n;
        this.init();
        this.flush();
    }

    @Override
    public void init() throws IOException {
        this.table = new TableDiskAccess(this.meta, "tbl");
        this.texts = new DataAccess(this.meta.dbfile("txt"));
        this.values = new DataAccess(this.meta.dbfile("atv"));
        super.init();
    }

    private void write() throws IOException {
        DataOutput out = new DataOutput(this.meta.dbfile("inf"));
        this.meta.write(out);
        out.writeString("TAGS");
        this.tagindex.write(out);
        out.writeString("ATTS");
        this.atnindex.write(out);
        out.writeString("PATH");
        this.pthindex.write(out);
        out.writeString("NS");
        this.ns.write(out);
        out.writeString("DOCS");
        this.docindex.write(out);
        out.write(0);
        out.close();
    }

    @Override
    public synchronized void flush() {
        if (!this.meta.prop.is(Prop.AUTOFLUSH)) {
            return;
        }
        try {
            if (this.meta.dirty) {
                this.write();
            }
            this.table.flush();
            this.texts.flush();
            this.values.flush();
            this.meta.dirty = false;
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.meta.dirty) {
            this.write();
        }
        this.table.close();
        this.texts.close();
        this.values.close();
        this.closeIndex(IndexToken.IndexType.TEXT);
        this.closeIndex(IndexToken.IndexType.ATTRIBUTE);
        this.closeIndex(IndexToken.IndexType.FULLTEXT);
    }

    @Override
    public synchronized void closeIndex(IndexToken.IndexType type) throws IOException {
        Index index = this.index(type);
        if (index == null) {
            return;
        }
        index.close();
        switch (type) {
            case TEXT: {
                this.txtindex = null;
                break;
            }
            case ATTRIBUTE: {
                this.atvindex = null;
                break;
            }
            case FULLTEXT: {
                this.ftxindex = null;
                break;
            }
            case PATH: {
                this.pthindex.close();
                break;
            }
        }
    }

    @Override
    public void setIndex(IndexToken.IndexType type, Index index) {
        this.meta.dirty = true;
        switch (type) {
            case TEXT: {
                this.txtindex = index;
                break;
            }
            case ATTRIBUTE: {
                this.atvindex = index;
                break;
            }
            case FULLTEXT: {
                this.ftxindex = index;
                break;
            }
            case PATH: {
                this.pthindex = (PathSummary)index;
                break;
            }
        }
    }

    @Override
    public byte[] text(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? Token.token((int)o) : this.txt(o, text);
    }

    @Override
    public long textItr(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? o & 0x7FFFFFFFFFL : Token.toLong(this.txt(o, text));
    }

    @Override
    public double textDbl(int pre, boolean text) {
        long o = this.textOff(pre);
        return DiskData.num(o) ? (double)(o & 0x7FFFFFFFFFL) : Token.toDouble(this.txt(o, text));
    }

    @Override
    public int textLen(int pre, boolean text) {
        long o = this.textOff(pre);
        if (DiskData.num(o)) {
            return Token.numDigits((int)o);
        }
        DataAccess da = text ? this.texts : this.values;
        int l = da.readNum(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? da.readNum() : l;
    }

    private byte[] txt(long o, boolean text) {
        byte[] txt = (text ? this.texts : this.values).readToken(o & 0x3FFFFFFFFFL);
        return DiskData.cpr(o) ? this.comp.unpack(txt) : txt;
    }

    private static boolean num(long o) {
        return (o & 0x8000000000L) != 0L;
    }

    private static boolean cpr(long o) {
        return (o & 0x4000000000L) != 0L;
    }

    @Override
    protected void delete(int pre, boolean text) {
        long old = this.textOff(pre);
        if (!DiskData.num(old)) {
            (text ? this.texts : this.values).free(old & 0x3FFFFFFFFFL, 0);
        }
    }

    @Override
    protected void text(int pre, byte[] value, boolean text) {
        long off;
        DataAccess store = text ? this.texts : this.values;
        long len = store.length();
        long v = Token.toSimpleInt(value);
        boolean vn = v != Integer.MIN_VALUE;
        byte[] vl = vn ? null : this.comp.pack(value);
        long old = this.textOff(pre);
        if (DiskData.num(old)) {
            off = len;
        } else {
            int l = vn ? 0 : vl.length + Num.length(vl.length);
            off = store.free(old & 0x3FFFFFFFFFL, l);
        }
        if (vn) {
            this.textOff(pre, v | 0x8000000000L);
        } else {
            store.writeToken(off, vl);
            this.textOff(pre, vl == value ? off : off | 0x4000000000L);
        }
    }

    @Override
    protected long index(int pre, byte[] value, boolean text) {
        long v = Token.toSimpleInt(value);
        if (v != Integer.MIN_VALUE) {
            return v | 0x8000000000L;
        }
        DataAccess store = text ? this.texts : this.values;
        long off = store.length();
        byte[] val = this.comp.pack(value);
        store.writeToken(off, val);
        return val == value ? off : off | 0x4000000000L;
    }
}

