/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.basex.core.Text;
import org.basex.data.DataText;
import org.basex.data.NSNode;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Namespaces {
    private final IntList uriStack = new IntList();
    private final TokenSet pref;
    private final TokenSet uri;
    final NSNode root;
    private boolean newns;
    private int uriL = 1;
    NSNode current;

    public Namespaces() {
        this.root = this.current = new NSNode(-1);
        this.pref = new TokenSet();
        this.uri = new TokenSet();
    }

    Namespaces(DataInput in) throws IOException {
        this.pref = new TokenSet(in);
        this.uri = new TokenSet(in);
        this.root = this.current = new NSNode(in, null);
    }

    void write(DataOutput out) throws IOException {
        this.pref.write(out);
        this.uri.write(out);
        this.current.write(out);
    }

    public NSNode add(byte[] p, byte[] u, int pre) {
        NSNode newNode = null;
        if (!this.newns) {
            newNode = new NSNode(pre);
            this.current = this.current.add(newNode);
            this.newns = true;
        }
        int k = this.addPref(p);
        int v = this.addURI(u);
        this.current.add(k, v);
        if (p.length == 0) {
            this.uriStack.set(this.uriL, v);
        }
        return newNode;
    }

    public boolean open() {
        this.uriStack.set(this.uriL + 1, this.uriStack.get(this.uriL));
        ++this.uriL;
        boolean n = this.newns;
        this.newns = false;
        return n;
    }

    public void close(int pre) {
        while (this.current.pre >= pre && this.current.par != null) {
            this.current = this.current.par;
        }
        --this.uriL;
        this.uriStack.set(this.uriL, this.uriStack.get(this.uriL - 1));
    }

    public int uri(byte[] n, boolean elem) {
        int u;
        if (this.uri.size() == 0) {
            return 0;
        }
        byte[] pr = Token.pref(n);
        int n2 = u = elem ? this.uriStack.get(this.uriL) : 0;
        if (pr.length != 0) {
            u = this.uri(pr, this.current);
        }
        return u;
    }

    public int size() {
        return this.uri.size();
    }

    public boolean rootEmpty() {
        return this.root.ch.length == 0;
    }

    public byte[] globalNS() {
        if (this.current.size == 0) {
            return Token.EMPTY;
        }
        if (this.current.size > 1) {
            return null;
        }
        NSNode n = this.current.ch[0];
        if (n.size != 0 || n.pre != 1) {
            return null;
        }
        int i = 0;
        while (i < n.vals.length) {
            if (this.pref.key(n.vals[i]).length == 0) {
                return this.uri.key(n.vals[i + 1]);
            }
            i += 2;
        }
        return null;
    }

    public byte[] uri(int id) {
        return this.uri.key(id);
    }

    public int uri(byte[] name, int pre) {
        return this.uri(Token.pref(name), this.current.find(pre));
    }

    public void delete(byte[] u) {
        int id = this.uri.id(u);
        if (id != 0) {
            this.current.delete(id);
        }
    }

    byte[] pref(int id) {
        return this.pref.key(id);
    }

    int[] get(int pre) {
        return this.current.find((int)pre).vals;
    }

    private int uri(byte[] pr, NSNode nd) {
        if (Token.eq(Token.XML, pr)) {
            return 0;
        }
        int i = this.pref.id(pr);
        if (i == 0) {
            return 0;
        }
        NSNode n = nd;
        while (n != null) {
            int u = n.uri(i);
            if (u != 0) {
                return u;
            }
            n = n.par;
        }
        return 0;
    }

    void delete(int pre, int size) {
        NSNode nd = this.current.find(pre);
        if (nd.pre == pre) {
            nd = nd.par;
        }
        while (nd != null) {
            nd.delete(pre, size);
            nd = nd.par;
        }
    }

    public int add(int pre, int par, byte[] p, byte[] u) {
        NSNode nd = this.current.find(par);
        NSNode t = new NSNode(pre);
        int k = this.addPref(p);
        int v = this.addURI(u);
        if (nd.pre == pre) {
            nd.add(k, v);
        } else {
            t.add(k, v);
            nd.add(t);
        }
        return v;
    }

    public int addURI(byte[] u) {
        return Math.abs(this.uri.add(u));
    }

    private int addPref(byte[] p) {
        return Math.abs(this.pref.add(p));
    }

    void setNearestRoot(NSNode n, int pre) {
        int uriI = this.uri(Token.EMPTY, pre);
        this.uriStack.set(this.uriL, uriI);
        this.uriStack.set(this.uriL - 1, uriI);
        this.setRoot(n);
    }

    void setRoot(NSNode n) {
        this.current = n;
    }

    void update(int pre, int ms, boolean insert, Set<NSNode> nodes) {
        this.update(this.root, pre, ms, insert, nodes != null ? nodes : new HashSet());
    }

    private void update(NSNode n, int pre, int ms, boolean insert, Set<NSNode> nodes) {
        if (!nodes.contains(n) && n.pre >= (insert ? pre : pre + ms)) {
            n.pre = n.pre + (insert ? ms : ms * -1);
        }
        int c = 0;
        while (c < n.size) {
            this.update(n.ch[c], pre, ms, insert, nodes);
            ++c;
        }
    }

    public byte[] table(int s, int e) {
        if (this.current.size == 0) {
            return Token.EMPTY;
        }
        Table t = new Table();
        t.header.add(DataText.TABLEID);
        t.header.add(DataText.TABLEPRE);
        t.header.add(DataText.TABLEDIST);
        t.header.add(DataText.TABLEPREF);
        t.header.add(DataText.TABLEURI);
        int i = 0;
        while (i < 3) {
            t.align.add(true);
            ++i;
        }
        this.table(t, this.current, s, e);
        return t.contents.size() != 0 ? t.finish() : Token.EMPTY;
    }

    private void table(Table t, NSNode n, int s, int e) {
        int i = 0;
        while (i < n.vals.length) {
            if (n.pre >= s && n.pre <= e) {
                TokenList tl = new TokenList();
                tl.add(n.vals[i + 1]);
                tl.add(n.pre);
                tl.add(n.pre - n.par.pre);
                tl.add(this.pref.key(n.vals[i]));
                tl.add(this.uri.key(n.vals[i + 1]));
                t.contents.add(tl);
            }
            i += 2;
        }
        i = 0;
        while (i < n.size) {
            this.table(t, n.ch[i], s, e);
            ++i;
        }
    }

    public byte[] info() {
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        this.info(map, this.current);
        TokenBuilder tb = new TokenBuilder();
        byte[][] byArray = map.keys();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] val = byArray[n2];
            tb.add("  ");
            TokenList key = map.get(val);
            key.sort(false);
            int ks = key.size();
            if (ks > 1 || key.get(0).length != 0) {
                if (key.size() != 1) {
                    tb.add("(");
                }
                int k = 0;
                while (k < ks) {
                    if (k != 0) {
                        tb.add(", ");
                    }
                    tb.add(key.get(k));
                    ++k;
                }
                if (ks != 1) {
                    tb.add(")");
                }
                tb.add(" = ");
            }
            tb.addExt("\"%\"" + Text.NL, new Object[]{val});
            ++n2;
        }
        return tb.finish();
    }

    private void info(TokenObjMap<TokenList> map, NSNode n) {
        int i = 0;
        while (i < n.vals.length) {
            byte[] key = this.uri.key(n.vals[i + 1]);
            byte[] val = this.pref.key(n.vals[i]);
            TokenList old = map.get(key);
            if (old == null) {
                old = new TokenList();
                map.add(key, old);
            }
            if (!old.contains(val)) {
                old.add(val);
            }
            i += 2;
        }
        NSNode[] nSNodeArray = n.ch;
        int n2 = n.ch.length;
        int n3 = 0;
        while (n3 < n2) {
            NSNode c = nSNodeArray[n3];
            this.info(map, c);
            ++n3;
        }
    }

    public String toString(int s, int e) {
        return this.current.print(this, s, e);
    }

    public String toString() {
        return this.toString(0, Integer.MAX_VALUE);
    }
}

