/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXLayout;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUICommands[] TOOLBAR;
    static final String[] MENUBAR;
    static final GUICommand[][] MENUITEMS;
    public static final GUICommands[] POPUP;
    public static final Cursor CURSORARROW;
    public static final Cursor CURSORHAND;
    public static final Cursor CURSORWAIT;
    public static final Cursor CURSORMOVEH;
    public static final Cursor CURSORMOVEV;
    public static final Cursor CURSORTEXT;
    public static final Cursor CURSORMOVE;
    public static final Color LGRAY;
    public static final Color GRAY;
    public static final Color DGRAY;
    public static final Color RED;
    public static final Color LRED;
    public static final Color GREEN;
    public static final Color BLUE;
    public static final Color PINK;
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color color5;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color colorA;
    public static Color color2A;
    public static Color color3A;
    public static Color colormarkA;
    public static Color colormark2A;
    private static final Color[] COLORS;
    public static Font dfont;
    public static Font lfont;
    public static Font font;
    public static Font mfont;
    public static int[] mfwidth;
    public static Font bfont;
    private static int[] dwidth;
    private static int[] lwidth;
    private static int[] fwidth;
    private static int[] bwidth;
    public static final int SHF = 1;
    public static final int ALT = 8;
    public static final int CTRL = 2;
    public static final int SC;

    static {
        GUICommands[] gUICommandsArray = new GUICommands[22];
        gUICommandsArray[0] = GUICommands.CREATE;
        gUICommandsArray[1] = GUICommands.OPEN;
        gUICommandsArray[2] = GUICommands.INFO;
        gUICommandsArray[3] = GUICommands.CLOSE;
        gUICommandsArray[5] = GUICommands.GOHOME;
        gUICommandsArray[6] = GUICommands.GOBACK;
        gUICommandsArray[7] = GUICommands.GOUP;
        gUICommandsArray[8] = GUICommands.GOFORWARD;
        gUICommandsArray[10] = GUICommands.SHOWXQUERY;
        gUICommandsArray[11] = GUICommands.SHOWINFO;
        gUICommandsArray[13] = GUICommands.SHOWTEXT;
        gUICommandsArray[14] = GUICommands.SHOWMAP;
        gUICommandsArray[15] = GUICommands.SHOWTREE;
        gUICommandsArray[16] = GUICommands.SHOWFOLDER;
        gUICommandsArray[17] = GUICommands.SHOWPLOT;
        gUICommandsArray[18] = GUICommands.SHOWTABLE;
        gUICommandsArray[19] = GUICommands.SHOWEXPLORE;
        gUICommandsArray[21] = GUICommands.SHOWHELP;
        TOOLBAR = gUICommandsArray;
        MENUBAR = new String[]{Text.MENUDB, Text.MENUQUERY, Text.MENUVIEW, Text.MENUNODES, Text.MENUOPTIONS, Text.MENUHELP};
        MENUITEMS = new GUICommand[][]{{GUICommands.CREATE, GUICommands.OPEN, GUICommands.MANAGE, GUICommand.EMPTY, GUICommands.ADD, GUICommands.DROP, GUICommands.EXPORT, GUICommands.INFO, GUICommands.CLOSE, GUICommand.EMPTY, GUICommands.SERVER, Prop.MAC ? null : GUICommand.EMPTY, Prop.MAC ? null : GUICommands.EXIT}, {GUICommands.SHOWXQUERY, GUICommands.SHOWINFO, GUICommand.EMPTY, GUICommands.EDITNEW, GUICommands.EDITOPEN, GUICommands.EDITSAVE, GUICommands.EDITSAVEAS, GUICommands.EDITCLOSE}, {GUICommands.SHOWMENU, GUICommands.SHOWBUTTONS, GUICommands.SHOWINPUT, GUICommands.SHOWSTATUS, GUICommand.EMPTY, GUICommands.SHOWTEXT, GUICommands.SHOWMAP, GUICommands.SHOWTREE, GUICommands.SHOWFOLDER, GUICommands.SHOWPLOT, GUICommands.SHOWTABLE, GUICommands.SHOWEXPLORE, GUICommand.EMPTY, GUICommands.FULL}, {GUICommands.COPY, GUICommands.PASTE, GUICommands.DELETE, GUICommands.INSERT, GUICommands.EDIT, GUICommand.EMPTY, GUICommands.COPYPATH, GUICommands.FILTER}, {GUICommands.RTEXEC, GUICommands.RTFILTER, GUICommand.EMPTY, GUICommands.COLOR, GUICommands.FONTS, GUICommands.MAPLAYOUT, GUICommands.TREEOPTIONS, Prop.MAC ? null : GUICommand.EMPTY, Prop.MAC ? null : GUICommands.PREFS}, {GUICommands.SHOWHELP, Prop.MAC ? null : GUICommand.EMPTY, GUICommands.SHOWCOMMUNITY, GUICommands.SHOWUPDATES, Prop.MAC ? null : GUICommand.EMPTY, Prop.MAC ? null : GUICommands.ABOUT}};
        GUICommands[] gUICommandsArray2 = new GUICommands[10];
        gUICommandsArray2[0] = GUICommands.GOBACK;
        gUICommandsArray2[1] = GUICommands.FILTER;
        gUICommandsArray2[3] = GUICommands.COPY;
        gUICommandsArray2[4] = GUICommands.PASTE;
        gUICommandsArray2[5] = GUICommands.DELETE;
        gUICommandsArray2[6] = GUICommands.INSERT;
        gUICommandsArray2[7] = GUICommands.EDIT;
        gUICommandsArray2[9] = GUICommands.COPYPATH;
        POPUP = gUICommandsArray2;
        CURSORARROW = new Cursor(0);
        CURSORHAND = new Cursor(12);
        CURSORWAIT = new Cursor(3);
        CURSORMOVEH = new Cursor(11);
        CURSORMOVEV = new Cursor(8);
        CURSORTEXT = new Cursor(2);
        CURSORMOVE = new Cursor(13);
        LGRAY = new Color(224, 224, 224);
        GRAY = new Color(160, 160, 160);
        DGRAY = new Color(64, 64, 64);
        RED = new Color(208, 0, 0);
        LRED = new Color(255, 200, 180);
        GREEN = new Color(0, 176, 0);
        BLUE = new Color(0, 64, 192);
        PINK = new Color(160, 0, 160);
        color1 = Color.white;
        COLORS = new Color[100];
        SC = Prop.MAC ? 4 : 2;
    }

    private GUIConstants() {
    }

    public static void init(GUIProp prop) {
        int r = prop.num(GUIProp.COLORRED);
        int g = prop.num(GUIProp.COLORGREEN);
        int b = prop.num(GUIProp.COLORBLUE);
        color2 = new Color(GUIConstants.col(r, 24), GUIConstants.col(g, 25), GUIConstants.col(b, 40));
        color3 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 32), GUIConstants.col(b, 44));
        color4 = new Color(GUIConstants.col(r, 48), GUIConstants.col(g, 50), GUIConstants.col(b, 40));
        color5 = new Color(GUIConstants.col(r, 140), GUIConstants.col(g, 100), GUIConstants.col(b, 70));
        colorA = new Color(GUIConstants.col(r, 110), GUIConstants.col(g, 150), GUIConstants.col(b, 160), 100);
        colormarkA = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320), 100);
        colormark2A = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 80), GUIConstants.col(b, 160), 100);
        colormark1 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 120), GUIConstants.col(b, 240));
        colormark2 = new Color(GUIConstants.col(r, 16), GUIConstants.col(g, 80), GUIConstants.col(b, 160));
        colormark3 = new Color(GUIConstants.col(r, 32), GUIConstants.col(g, 160), GUIConstants.col(b, 320));
        colormark4 = new Color(GUIConstants.col(r, 1), GUIConstants.col(g, 40), GUIConstants.col(b, 80));
        int l = 1;
        while (l < COLORS.length + 1) {
            GUIConstants.COLORS[l - 1] = new Color(Math.max(255 - l * r, 0), Math.max(255 - l * g, 0), Math.max(255 - l * b, 0));
            ++l;
        }
        Color c = COLORS[16];
        color2A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 40);
        color3A = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
        dfont = new Font(prop.get(GUIProp.MONOFONT), 0, UIManager.getFont("TextArea.font").getSize() - 1);
        dwidth = new Container().getFontMetrics(dfont).getWidths();
        GUIConstants.initFonts(prop);
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    public static void initFonts(GUIProp prop) {
        Container comp = new Container();
        String f = prop.get(GUIProp.FONT);
        int type = prop.num(GUIProp.FONTTYPE);
        int size = prop.num(GUIProp.FONTSIZE);
        font = new Font(f, type, size);
        mfont = new Font(prop.get(GUIProp.MONOFONT), type, size);
        bfont = new Font(f, 1, size);
        lfont = new Font(f, type, size + 8);
        fwidth = comp.getFontMetrics(font).getWidths();
        lwidth = comp.getFontMetrics(lfont).getWidths();
        mfwidth = comp.getFontMetrics(mfont).getWidths();
        bwidth = comp.getFontMetrics(bfont).getWidths();
    }

    public static int[] fontWidths(Font f) {
        if (f == font) {
            return fwidth;
        }
        if (f == mfont) {
            return mfwidth;
        }
        if (f == bfont) {
            return bwidth;
        }
        if (f == lfont) {
            return lwidth;
        }
        if (f == dfont) {
            return dwidth;
        }
        return new Container().getFontMetrics(f).getWidths();
    }

    private static int col(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    public static enum Fill {
        PLAIN,
        NONE,
        GRADIENT;

    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXLayout.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

