/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.basex.gui.GUI;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXButton;
import org.basex.util.Util;

public final class GUIMenu
extends JMenuBar {
    private final JMenuItem[] items;
    final GUI gui;

    GUIMenu(GUI main) {
        this.gui = main;
        String sm = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? "meta" : "ctrl";
        int c = 0;
        int b = 0;
        while (b < GUIConstants.MENUBAR.length) {
            int i = 0;
            while (i < GUIConstants.MENUITEMS[b].length) {
                ++c;
                ++i;
            }
            ++b;
        }
        this.items = new JMenuItem[c];
        c = 0;
        StringBuilder gmnem = new StringBuilder();
        int b2 = 0;
        while (b2 < GUIConstants.MENUBAR.length) {
            JMenu menu = new JMenu(GUIConstants.MENUBAR[b2]);
            BaseXButton.setMnemonics(gmnem, menu);
            StringBuilder mnem = new StringBuilder();
            int i = 0;
            while (i < GUIConstants.MENUITEMS[b2].length) {
                GUICommand cmd = GUIConstants.MENUITEMS[b2][i];
                if (cmd == GUICommand.EMPTY) {
                    menu.addSeparator();
                } else if (cmd != null) {
                    JMenuItem item = GUIMenu.newItem(cmd, this.gui, mnem);
                    String sc = cmd.key();
                    if (sc != null) {
                        item.setAccelerator(KeyStroke.getKeyStroke(Util.info(sc, sm)));
                    }
                    this.items[c++] = item;
                    menu.add(item);
                }
                ++i;
            }
            this.add(menu);
            ++b2;
        }
    }

    public static JMenuItem newItem(final GUICommand cmd, final GUI gui, StringBuilder mnem) {
        String desc = cmd.label();
        JMenuItem item = cmd.checked() ? new JCheckBoxMenuItem(desc) : new JMenuItem(desc);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cmd.execute(gui);
            }
        });
        BaseXButton.setMnemonics(mnem, item);
        item.setToolTipText(cmd.help());
        return item;
    }

    void refresh() {
        int c = 0;
        int b = 0;
        while (b < GUIConstants.MENUBAR.length) {
            int i = 0;
            while (i < GUIConstants.MENUITEMS[b].length) {
                GUICommand item = GUIConstants.MENUITEMS[b][i];
                if (item != GUICommand.EMPTY && item != null) {
                    item.refresh(this.gui, this.items[c++]);
                }
                ++i;
            }
            ++b;
        }
    }
}

