/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import org.basex.build.file.CSVParser;
import org.basex.build.file.HTMLParser;
import org.basex.build.file.ParserProp;
import org.basex.build.xml.CatalogWrapper;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public final class DialogParsing
extends BaseXBack {
    public final BaseXCombo parser;
    private final BaseXCheckBox intparse;
    private final BaseXCheckBox dtd;
    private final BaseXCheckBox chop;
    private final BaseXCheckBox usecat;
    private final BaseXTextField cfile;
    private final BaseXButton browsec;
    private final Dialog dialog;
    private BaseXBack parseropts;
    private final BaseXBack xmlopts;
    private final BaseXBack csvopts;
    private final BaseXCheckBox header;
    private final BaseXCombo separator;
    private final BaseXCombo format;
    private final BaseXCombo cencoding;
    private final BaseXBack textopts;
    private final BaseXCheckBox lines;
    private final BaseXCombo tencoding;
    private final BaseXBack main;
    private ParserProp props;

    public DialogParsing(Dialog d) {
        this.dialog = d;
        this.main = new BaseXBack(new TableLayout(3, 1)).border(8);
        Prop prop = this.dialog.gui.context.prop;
        try {
            this.props = new ParserProp(prop.get(Prop.PARSEROPT));
        }
        catch (IOException ex) {
            this.props = new ParserProp();
        }
        StringList parsers = new StringList();
        parsers.add("xml");
        if (HTMLParser.available()) {
            parsers.add("html");
        }
        parsers.add("csv");
        parsers.add("text");
        this.parser = new BaseXCombo(d, parsers.toArray());
        this.parser.setSelectedItem(prop.get(Prop.PARSER));
        this.intparse = new BaseXCheckBox(Text.CREATEINTPARSE, prop.is(Prop.INTPARSE), 0, d);
        this.dtd = new BaseXCheckBox(Text.CREATEDTD, prop.is(Prop.DTD), 12, d);
        this.chop = new BaseXCheckBox(Text.CREATECHOP, prop.is(Prop.CHOP), 0, d);
        this.cfile = new BaseXTextField(prop.get(Prop.CATFILE), d);
        this.browsec = new BaseXButton(Text.BUTTONBROWSE, d);
        this.browsec.setMnemonic();
        this.usecat = new BaseXCheckBox(Text.USECATFILE, !prop.get(Prop.CATFILE).isEmpty(), 0, d);
        this.lines = new BaseXCheckBox("Lines", this.props.is(ParserProp.LINES), 0, d);
        this.header = new BaseXCheckBox("Header", this.props.is(ParserProp.HEADER), 0, d);
        this.separator = new BaseXCombo(d, CSVParser.SEPARATORS);
        this.separator.setSelectedItem(this.props.get(ParserProp.SEPARATOR));
        this.format = new BaseXCombo(d, CSVParser.FORMATS);
        this.format.setSelectedItem(this.props.get(ParserProp.FORMAT));
        this.cencoding = DialogExport.encoding(d, this.props.get(ParserProp.ENCODING));
        this.tencoding = DialogExport.encoding(d, this.props.get(ParserProp.ENCODING));
        this.xmlopts = new BaseXBack(new TableLayout(8, 1));
        this.csvopts = new BaseXBack(new TableLayout(2, 1));
        this.textopts = new BaseXBack(new TableLayout(3, 1));
        this.createOptionsPanels();
        this.setLayout(new TableLayout(1, 1));
        this.options(this.parser.getSelectedItem().toString());
        this.add(this.main);
    }

    void createOptionsPanels() {
        this.xmlopts.add(this.intparse);
        this.xmlopts.add(new BaseXLabel(Text.INTPARSEINFO, true, false));
        this.xmlopts.add(this.dtd);
        this.xmlopts.add(this.chop);
        this.xmlopts.add(new BaseXLabel(Text.CHOPPINGINFO, false, false).border(0, 0, 8, 0));
        this.xmlopts.add(new BaseXLabel());
        boolean rsen = CatalogWrapper.available();
        BaseXBack fl = new BaseXBack(new TableLayout(2, 2, 8, 0));
        this.usecat.setEnabled(rsen);
        fl.add(this.usecat);
        fl.add(new BaseXLabel());
        this.cfile.setEnabled(rsen);
        fl.add(this.cfile);
        this.browsec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogParsing.this.catchoose();
            }
        });
        this.browsec.setEnabled(rsen);
        fl.add(this.browsec);
        this.xmlopts.add(fl);
        if (!rsen) {
            BaseXBack rs = new BaseXBack(new TableLayout(2, 1));
            rs.add(new BaseXLabel(Text.USECATHLP).color(GUIConstants.DGRAY));
            rs.add(new BaseXLabel(Text.USECATHLP2).color(GUIConstants.DGRAY));
            this.xmlopts.add(rs);
        }
        BaseXBack p = new BaseXBack(new TableLayout(3, 2, 8, 4));
        p.add(new BaseXLabel(String.valueOf(Text.INFOENCODING) + ":", true, false));
        p.add(this.cencoding);
        p.add(new BaseXLabel(Text.SEPARATORINFO, true, false));
        p.add(this.separator);
        p.add(new BaseXLabel(Text.FORMINFO, true, false));
        p.add(this.format);
        this.csvopts.add(p);
        p = new BaseXBack(new TableLayout(2, 1));
        p.add(this.header);
        p.add(new BaseXLabel(Text.HEADERINFO, true, false));
        this.csvopts.add(p);
        p = new BaseXBack(new TableLayout(1, 2, 8, 4));
        p.add(new BaseXLabel(String.valueOf(Text.INFOENCODING) + ":", true, false));
        p.add(this.tencoding);
        this.textopts.add(p);
        this.textopts.add(this.lines);
        this.textopts.add(new BaseXLabel(Text.LINESINFO, true, false));
    }

    void options(String type) {
        this.main.removeAll();
        BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
        p.add(new BaseXLabel(Text.CREATEFORMAT, true, true));
        p.add(this.parser);
        this.main.add(p);
        this.main.add(new BaseXLabel(Text.FORMATINFO, true, false));
        if (type.equals("xml")) {
            this.parseropts = this.xmlopts;
        } else if (type.equals("html")) {
            this.parseropts = new BaseXBack();
        } else if (type.equals("csv")) {
            this.parseropts = this.csvopts;
        } else if (type.equals("text")) {
            this.parseropts = this.textopts;
        }
        this.main.add(this.parseropts);
        this.main.revalidate();
        this.parser.requestFocusInWindow();
    }

    void catchoose() {
        GUIProp gprop = this.dialog.gui.gprop;
        BaseXFileChooser fc = new BaseXFileChooser(Text.CREATETITLE, gprop.get(GUIProp.CREATEPATH), this.dialog.gui);
        fc.addFilter("XML Documents", ".xml");
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file != null) {
            this.cfile.setText(file.path());
        }
    }

    void action(Object cmp) {
        String type = this.parser.getSelectedItem().toString();
        if (type.equals("xml")) {
            boolean ip = this.intparse.isSelected();
            boolean uc = this.usecat.isSelected();
            this.intparse.setEnabled(!uc);
            this.usecat.setEnabled(!ip && CatalogWrapper.available());
            this.cfile.setEnabled(uc);
            this.browsec.setEnabled(uc);
        }
        if (cmp == this.parser) {
            this.options(type);
        }
    }

    public void close() {
        String type = this.parser.getSelectedItem().toString();
        BaseXCombo cb = type.equals("text") ? this.tencoding : this.cencoding;
        this.props.set(ParserProp.ENCODING, cb.getSelectedItem().toString());
        this.props.set(ParserProp.FORMAT, this.format.getSelectedItem().toString());
        this.props.set(ParserProp.HEADER, this.header.isSelected());
        this.props.set(ParserProp.SEPARATOR, this.separator.getSelectedItem().toString());
        this.props.set(ParserProp.LINES, this.lines.isSelected());
        this.dialog.gui.set(Prop.PARSEROPT, this.props.toString());
        this.dialog.gui.set(Prop.CHOP, this.chop.isSelected());
        this.dialog.gui.set(Prop.DTD, this.dtd.isSelected());
        this.dialog.gui.set(Prop.INTPARSE, this.intparse.isSelected());
        this.dialog.gui.set(Prop.PARSER, this.parser.getSelectedItem().toString());
        this.dialog.gui.set(Prop.CATFILE, this.usecat.isSelected() ? this.cfile.getText() : "");
    }
}

