/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXPassword;
import org.basex.util.Util;

final class DialogPass
extends Dialog {
    private final BaseXPassword pass = new BaseXPassword(this);
    private final BaseXBack buttons;
    private final BaseXLabel info;

    DialogPass(GUI main) {
        super(main, Text.ALTERPW);
        this.pass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!BaseXKeys.modifier(e)) {
                    DialogPass.this.action(BaseXKeys.ENTER.is(e) ? e.getSource() : null);
                }
            }
        });
        this.info = new BaseXLabel(" ");
        BaseXBack p = new BaseXBack(new BorderLayout(0, 8));
        p.add((Component)this.pass, "North");
        p.add((Component)this.info, "Center");
        this.set(p, "Center");
        this.buttons = DialogPass.newButtons(this, Text.BUTTONOK, Text.BUTTONCANCEL);
        this.set(this.buttons, "South");
        this.action(null);
        this.finish(null);
    }

    @Override
    public void action(Object cmp) {
        String nm = this.pass();
        this.ok = !nm.isEmpty() && nm.matches("[^ ;'\\\"]*");
        this.info.setText(this.ok || nm.isEmpty() ? null : Util.info(Text.INVALID, Text.SERVERPW), GUIConstants.Msg.ERROR);
        DialogPass.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
    }

    String pass() {
        return new String(this.pass.getPassword());
    }
}

