/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

public final class BaseXSlider
extends BaseXPanel {
    private static final double SLIDERW = 20.0;
    private final Dialog dl;
    private final int min;
    private final int max;
    private ActionListener al;
    private int curr;
    private int oldCurr = -1;
    private int mouseX;

    public BaseXSlider(ActionListener list, int mn, int mx, int i, Window w) {
        this(mn, mx, i, w);
        this.al = list;
    }

    public BaseXSlider(int mn, int mx, int i, Window w) {
        super(w);
        this.min = mn;
        this.max = mx;
        this.curr = i;
        this.dl = w instanceof Dialog ? (Dialog)w : null;
        this.mode(GUIConstants.Fill.NONE).setFocusable(true);
        BaseXLayout.setHeight(this, this.getFont().getSize() + 3);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXSlider.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                BaseXSlider.this.repaint();
            }
        });
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int value() {
        return this.curr;
    }

    public void value(int v) {
        this.curr = v;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int hh = h / 2;
        g.setColor(this.hasFocus() ? Color.white : GUIConstants.LGRAY);
        g.fillRect(0, hh - 2, w, 4);
        g.setColor(Color.black);
        g.drawLine(0, hh - 2, w, hh - 2);
        g.drawLine(0, hh - 2, 0, hh + 2);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(w - 1, hh - 2, w - 1, hh + 2);
        g.drawLine(0, hh + 2, w, hh + 2);
        double x = (double)(this.curr - this.min) * ((double)w - 20.0) / (double)(this.max - this.min);
        BaseXLayout.drawCell(g, (int)x, (int)(x + 20.0), hh - 5, hh + 5, this.oldCurr != -1);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocusInWindow();
        this.mouseX = e.getX();
        double w = (double)this.getWidth() - 20.0;
        double r = this.max - this.min;
        double x = (double)(this.curr - this.min) * w / r;
        if ((double)this.mouseX < x || (double)this.mouseX >= x + 20.0) {
            this.curr = (int)((double)this.mouseX * r / w + (double)this.min);
        }
        this.oldCurr = this.curr;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.oldCurr = -1;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double prop = (double)((this.max - this.min) * (this.mouseX - e.getX())) / ((double)this.getWidth() - 20.0);
        int old = this.curr;
        this.curr = Math.max(this.min, Math.min(this.max, (int)((double)this.oldCurr - prop)));
        if (this.curr != old) {
            if (this.dl != null) {
                this.dl.action(null);
            } else {
                this.al.actionPerformed(null);
            }
            this.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int old = this.curr;
        if (BaseXKeys.PREV.is(e) || BaseXKeys.PREVLINE.is(e)) {
            this.curr = Math.max(this.min, this.curr - 1);
        } else if (BaseXKeys.NEXT.is(e) || BaseXKeys.NEXTLINE.is(e)) {
            this.curr = Math.min(this.max, this.curr + 1);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            this.curr = Math.max(this.min, this.curr + 10);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            this.curr = Math.min(this.max, this.curr - 10);
        } else if (BaseXKeys.LINESTART.is(e)) {
            this.curr = this.min;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.curr = this.max;
        }
        if (this.curr != old) {
            if (this.dl != null) {
                this.dl.action(null);
            } else {
                this.al.actionPerformed(null);
            }
            this.repaint();
        }
    }
}

