/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXBar;
import org.basex.gui.layout.BaseXSyntax;
import org.basex.gui.layout.BaseXTextTokens;

final class BaseXTextRenderer
extends BaseXBack {
    private final BaseXBar bar;
    private Font font;
    private Font dfont;
    private Font bfont;
    private int fontH;
    private int[] fwidth = GUIConstants.mfwidth;
    private Color color;
    private boolean high;
    private int wordW;
    private String search;
    private int off;
    private int x;
    private int y;
    private int w;
    private int h;
    private transient BaseXTextTokens text;
    private transient BaseXSyntax syntax = BaseXSyntax.SIMPLE;
    private boolean cursor;

    BaseXTextRenderer(BaseXTextTokens t, BaseXBar b) {
        this.mode(GUIConstants.Fill.NONE).setFont(GUIConstants.dfont);
        this.text = t;
        this.bar = b;
    }

    @Override
    public void setFont(Font f) {
        this.dfont = f;
        this.bfont = f.deriveFont(1);
        this.font(f);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.write(g, this.bar.pos());
    }

    void setText(BaseXTextTokens t) {
        this.text = t;
    }

    int find(String s, boolean b) {
        int os = this.search == null ? 0 : this.search.length();
        int ns = s.length();
        String string = this.search = ns != 0 ? s.toLowerCase() : null;
        return ns < os ? 0 : this.find(b, ns == os);
    }

    int find(boolean b, boolean s) {
        if (this.search == null) {
            return 0;
        }
        int hh = this.h;
        int lp = 0;
        int ly = 0;
        int sp = this.text.cursor();
        this.h = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        this.init(g, 0);
        while (this.more(g)) {
            if (this.searched()) {
                int np = this.text.pos();
                int ny = this.y - this.fontH;
                if (np >= sp && (np > sp || !s || b)) {
                    if (b && lp == 0 && np >= sp) {
                        sp = Integer.MAX_VALUE;
                    } else {
                        this.h = hh;
                        this.text.setCaret(b ? lp : np);
                        return b ? ly : ny;
                    }
                }
                lp = np;
                ly = ny;
            }
            this.next();
        }
        this.h = hh;
        if (sp == 0 || sp == Integer.MAX_VALUE) {
            this.text.setCaret(lp);
            return ly;
        }
        this.text.setCaret(0);
        return this.find(b, s);
    }

    int[] pos() {
        int hh = this.h;
        this.h = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        int col = 1;
        int line = 1;
        this.init(g, 0);
        boolean more = true;
        while (this.more(g)) {
            int p = this.text.pos();
            while (this.text.more()) {
                boolean bl = more = this.text.pos() < this.text.cursor();
                if (!more) break;
                this.text.next();
                ++col;
            }
            if (!more) break;
            this.text.pos(p);
            if (!this.next()) continue;
            ++line;
            col = 1;
        }
        this.h = hh;
        return new int[]{line, col};
    }

    private void font(Font f) {
        this.font = f;
        this.off = f.getSize() + 1 >> 2;
        this.fontH = f.getSize() + this.off;
        this.fwidth = GUIConstants.fontWidths(f);
    }

    @Override
    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        this.w = Integer.MAX_VALUE;
        this.h = Integer.MAX_VALUE;
        this.init(g, 0);
        int max = 0;
        while (this.more(g)) {
            if (this.text.curr() == 10) {
                max = Math.max(this.x, max);
            }
            this.next();
        }
        return new Dimension(Math.max(this.x, max) + this.fwidth[32], this.y + this.fwidth[32]);
    }

    private void init(Graphics g, int pos) {
        this.font = this.dfont;
        this.color = Color.black;
        this.syntax.init();
        this.text.init();
        this.x = this.off;
        this.y = this.off + this.fontH - pos - 2;
        if (g != null) {
            g.setFont(this.font);
        }
    }

    void calc() {
        this.w = this.getWidth() - (this.off >> 1);
        this.h = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        this.init(g, 0);
        while (this.more(g)) {
            this.next();
        }
        this.h = this.getHeight() + this.fontH;
        this.bar.height(this.y + this.off);
    }

    int cursorY() {
        int hh = this.h;
        this.h = Integer.MAX_VALUE;
        Graphics g = this.getGraphics();
        this.init(g, 0);
        while (this.more(g) && !this.text.edited()) {
            this.next();
        }
        this.h = hh;
        return this.y - this.fontH;
    }

    private void write(Graphics g, int pos) {
        this.init(g, pos);
        while (this.more(g)) {
            this.write(g);
        }
        if (this.cursor && this.text.cursor() == this.text.size()) {
            this.cursor(g, this.x);
        }
    }

    private boolean more(Graphics g) {
        if (!this.text.moreWords()) {
            return false;
        }
        int ww = 0;
        int p = this.text.pos();
        while (this.text.more()) {
            int ch = this.text.next();
            if (ch == 2) {
                this.font(this.bfont);
                continue;
            }
            if (ch == 3) {
                this.font(this.dfont);
                continue;
            }
            ww += this.charW(g, ch);
        }
        this.text.pos(p);
        if (this.x + ww > this.w) {
            this.x = this.off;
            this.y += this.fontH;
        }
        this.wordW = ww;
        return this.y < this.h;
    }

    private boolean next() {
        int ch = this.text.curr();
        if (ch == 10 || ch == 1) {
            this.x = this.off;
            this.y += this.fontH >> (ch == 10 ? 0 : 1);
            return true;
        }
        this.x += this.wordW;
        return false;
    }

    private void write(Graphics g) {
        if (this.high) {
            this.high = false;
        } else {
            this.color = this.isEnabled() ? this.syntax.getColor(this.text) : Color.gray;
        }
        int ch = this.text.curr();
        if (this.y > 0 && this.y < this.h) {
            int p;
            if (ch == 4) {
                this.color = GUIConstants.GREEN;
                this.high = true;
            }
            if (this.text.error()) {
                g.setColor(GUIConstants.LRED);
                g.fillRect(this.x, this.y - this.fontH + 4, this.wordW, this.fontH);
            }
            int xx = this.x;
            if (this.text.markStart()) {
                p = this.text.pos();
                while (this.text.more()) {
                    int cw = this.charW(g, this.text.curr());
                    if (this.text.inMark()) {
                        g.setColor(GUIConstants.color(3));
                        g.fillRect(xx, this.y - this.fontH + 4, cw, this.fontH);
                    }
                    xx += cw;
                    this.text.next();
                }
                this.text.pos(p);
            }
            if (this.search != null && this.searched()) {
                int cw = 0;
                int c = 0;
                while (c < this.search.length()) {
                    cw += this.charW(g, this.search.charAt(c));
                    ++c;
                }
                g.setColor(GUIConstants.color(this.text.cursor() == this.text.pos() ? 5 : 2));
                g.fillRect(this.x, this.y - this.fontH + 4, cw, this.fontH);
            }
            if (ch > 32) {
                g.setColor(this.color);
                g.drawString(this.text.nextWord(), this.x, this.y);
            } else if (ch <= 4) {
                g.setFont(this.font);
            }
            if (this.cursor && this.text.edited()) {
                xx = this.x;
                p = this.text.pos();
                while (this.text.more()) {
                    if (this.text.cursor() == this.text.pos()) {
                        this.cursor(g, xx);
                        break;
                    }
                    xx += this.charW(g, this.text.next());
                }
                this.text.pos(p);
            }
        }
        this.next();
    }

    private boolean searched() {
        int sl = this.search.length();
        int wl = this.text.length();
        if (wl < sl) {
            return false;
        }
        int p = this.text.pos();
        int s = -1;
        while (++s != sl) {
            if (Character.toLowerCase(this.text.next()) != this.search.charAt(s)) break;
        }
        this.text.pos(p);
        return s == sl;
    }

    private void cursor(Graphics g, int xx) {
        g.setColor(Color.black);
        g.drawLine(xx, this.y - this.fontH + 4, xx, this.y + 3);
    }

    void stopSelect() {
        this.text.checkMark();
    }

    void select(int pos, Point p, boolean finish) {
        if (!finish) {
            this.text.noMark();
        }
        p.y -= 3;
        Graphics g = this.getGraphics();
        this.init(g, pos);
        if (p.y > this.y - this.fontH) {
            int s = this.text.pos();
            block0: while (true) {
                if (p.x > this.x && p.y < this.y - this.fontH) {
                    this.text.pos(s);
                    break;
                }
                if (!this.more(g)) {
                    while (this.text.more()) {
                        this.text.next();
                    }
                    break;
                }
                if (p.x <= this.x && p.y < this.y) break;
                if (p.x > this.x && p.x <= this.x + this.wordW && p.y > this.y - this.fontH && p.y <= this.y) {
                    while (this.text.more()) {
                        int ww = this.charW(g, this.text.curr());
                        if (p.x < this.x + ww) break block0;
                        this.x += ww;
                        this.text.next();
                    }
                    break;
                }
                s = this.text.pos();
                this.next();
            }
            if (!finish) {
                this.text.startMark();
            } else {
                this.text.endMark();
            }
            this.text.setCaret();
        }
        this.repaint();
    }

    private int charW(Graphics g, int cp) {
        return cp < 32 || g == null ? (cp == 9 ? this.fwidth[32] * 2 : 0) : (cp < 256 ? this.fwidth[cp] : (cp >= 55296 && cp <= 56320 ? 0 : g.getFontMetrics().charWidth(cp)));
    }

    int fontH() {
        return this.fontH;
    }

    void cursor(boolean c) {
        this.cursor = c;
    }

    boolean cursor() {
        return this.cursor;
    }

    void setSyntax(BaseXSyntax s) {
        this.syntax = s;
    }

    BaseXSyntax getSyntax() {
        return this.syntax;
    }
}

