/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import org.basex.data.DataText;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXSyntax;
import org.basex.gui.layout.BaseXTextTokens;

public final class XMLSyntax
extends BaseXSyntax {
    private int quote;
    private boolean tag;
    private boolean elem;

    @Override
    public void init() {
        this.quote = 0;
        this.tag = false;
    }

    @Override
    public Color getColor(BaseXTextTokens text) {
        int ch = text.curr();
        if (this.tag) {
            if (this.quote != 0) {
                if (this.quote == ch) {
                    this.quote = 0;
                }
                return GUIConstants.RED;
            }
            if (ch == 34 || ch == 39) {
                this.quote = ch;
                return GUIConstants.RED;
            }
            if (ch == 62) {
                this.tag = false;
            }
            if (ch == 61 || ch == 62 || ch == 47) {
                return GUIConstants.BLUE;
            }
            if (this.elem) {
                if (ch <= 32) {
                    this.elem = false;
                }
                return GUIConstants.BLUE;
            }
            return GUIConstants.PINK;
        }
        if (ch == 60) {
            this.tag = true;
            this.elem = true;
            return GUIConstants.BLUE;
        }
        return Color.black;
    }

    @Override
    public byte[] commentOpen() {
        return DataText.COMM_O;
    }

    @Override
    public byte[] commentEnd() {
        return DataText.COMM_C;
    }
}

