/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.gui.GUICommands;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.view.ViewNotifier;

public abstract class View
extends BaseXPanel {
    protected View(String name, byte[] hlp, ViewNotifier man) {
        super(hlp, man.gui);
        this.mode(man.gui.gprop.is(GUIProp.GRADIENT) ? GUIConstants.Fill.GRADIENT : GUIConstants.Fill.PLAIN);
        this.setFocusable(true);
        this.setBackground(Color.white);
        this.setName(name);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addComponentListener(this);
        man.add(this);
    }

    public abstract void refreshInit();

    public abstract void refreshFocus();

    public abstract void refreshMark();

    public abstract void refreshContext(boolean var1, boolean var2);

    public abstract void refreshLayout();

    public abstract void refreshUpdate();

    public abstract boolean visible();

    public abstract void visible(boolean var1);

    protected abstract boolean db();

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.gui.updating && this.gui.gprop.is(GUIProp.MOUSEFOCUS)) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.gui.updating) {
            this.gui.cursor(GUIConstants.CURSORARROW);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.gui.updating) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.gui.updating) {
            return;
        }
        if (BaseXKeys.ESCAPE.is(e)) {
            this.gui.fullscreen(false);
        } else if (BaseXKeys.SPACE.is(e)) {
            this.gui.notify.mark(BaseXKeys.sc(e) ? 2 : (e.isShiftDown() ? 1 : 0), null);
        } else if (BaseXKeys.ENTER.is(e)) {
            GUICommands.FILTER.execute(this.gui);
        } else if (BaseXKeys.GOBACK2.is(e)) {
            GUICommands.GOBACK.execute(this.gui);
        }
    }

    @Override
    public final String toString() {
        return this.getName();
    }
}

