/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.explore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.basex.core.Text;
import org.basex.core.cmd.Find;
import org.basex.data.Data;
import org.basex.data.StatsKey;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDSlider;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.view.explore.ExploreView;
import org.basex.index.Names;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

final class ExploreArea
extends BaseXPanel
implements ActionListener {
    private static final int COMPW = 150;
    private static final String PATEX = "[% = \"%\"]";
    private static final String PATSUB = "[% contains text \"%\"]";
    private static final String PATNUM = "[% >= % and % <= %]";
    private static final String PATSIMPLE = "[%]";
    private final ExploreView main;
    private final BaseXBack panel;
    private final BaseXTextField all;
    private String last = "";

    ExploreArea(ExploreView m) {
        super(m.gui);
        this.main = m;
        this.layout(new BorderLayout(0, 5)).mode(GUIConstants.Fill.NONE);
        this.all = new BaseXTextField(this.gui);
        this.all.addKeyListener(this.main);
        this.all.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExploreArea.this.query(false);
            }
        });
        this.add((Component)this.all, "North");
        this.panel = new BaseXBack(GUIConstants.Fill.NONE).layout(new TableLayout(20, 2, 10, 5));
        this.add((Component)this.panel, "Center");
    }

    void init() {
        this.panel.removeAll();
        this.panel.revalidate();
        this.panel.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Data data = this.gui.context.data();
        if (!this.main.visible() || data == null) {
            return;
        }
        boolean pi = data.meta.pathindex;
        if (!pi || this.panel.getComponentCount() != 0) {
            if (!pi) {
                this.init();
            }
            return;
        }
        if (!pi) {
            return;
        }
        this.all.help(Text.HELPSEARCHXML);
        this.addKeys(this.gui.context.data());
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void addInput(int pos) {
        BaseXTextField txt = new BaseXTextField(this.gui);
        BaseXLayout.setWidth(txt, 150);
        BaseXLayout.setHeight(txt, txt.getFont().getSize() + 11);
        txt.setMargin(new Insets(0, 0, 0, 10));
        txt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExploreArea.this.query(false);
            }
        });
        txt.addKeyListener(this.main);
        this.panel.add((Component)txt, pos);
    }

    private void addKeys(Data data) {
        TokenList tl = new TokenList();
        int cs = this.panel.getComponentCount();
        int c = 0;
        while (c < cs) {
            String elem;
            BaseXCombo combo = (BaseXCombo)this.panel.getComponent(c);
            if (combo.getSelectedIndex() != 0 && !(elem = combo.getSelectedItem().toString()).startsWith("@")) {
                tl.add(Token.token(elem));
            }
            c += 2;
        }
        TokenList tmp = data.pthindex.desc(tl, true, false);
        String[] keys = this.entries(tmp.toArray());
        BaseXCombo cm = new BaseXCombo(this.gui, keys);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        if (tmp.size() == 0) {
            cm.setEnabled(false);
        }
        this.panel.add(cm);
        this.panel.add(new BaseXLabel(""));
    }

    private void addCombo(String[] values, int pos) {
        BaseXCombo cm = new BaseXCombo(this.gui, values);
        BaseXLayout.setWidth(cm, 150);
        cm.addActionListener(this);
        cm.addKeyListener(this.main);
        this.panel.add((Component)cm, pos);
    }

    private void addSlider(double min, double max, int pos, boolean itr) {
        BaseXDSlider sl = new BaseXDSlider(this.gui, min, max, this);
        BaseXLayout.setWidth(sl, 450);
        sl.itr = itr;
        sl.addKeyListener(this.main);
        this.panel.add((Component)sl, pos);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            Object source = e.getSource();
            int cp = 0;
            int cs = this.panel.getComponentCount();
            int c = 0;
            while (c < cs) {
                if (this.panel.getComponent(c) == source) {
                    cp = c;
                }
                ++c;
            }
            if (!(cp & true)) {
                boolean selected;
                BaseXCombo combo = (BaseXCombo)source;
                this.panel.remove(cp + 1);
                Data data = this.gui.context.data();
                boolean bl = selected = combo.getSelectedIndex() != 0;
                if (selected) {
                    String item = combo.getSelectedItem().toString();
                    boolean att = item.startsWith("@");
                    Names names = att ? data.atnindex : data.tagindex;
                    byte[] key = Token.token(att ? item.substring(1) : item);
                    StatsKey stat = names.stat(names.id(key));
                    switch (stat.kind) {
                        case INT: {
                            this.addSlider(stat.min, stat.max, cp + 1, true);
                            break;
                        }
                        case DBL: {
                            this.addSlider(stat.min, stat.max, cp + 1, false);
                            break;
                        }
                        case CAT: {
                            this.addCombo(this.entries(stat.cats.keys()), cp + 1);
                            break;
                        }
                        case TEXT: {
                            this.addInput(cp + 1);
                            break;
                        }
                        case NONE: {
                            this.panel.add((Component)new BaseXLabel(""), cp + 1);
                        }
                    }
                } else {
                    this.panel.add((Component)new BaseXLabel(""), cp + 1);
                }
                while (cp + 2 < this.panel.getComponentCount()) {
                    this.panel.remove(cp + 2);
                    this.panel.remove(cp + 2);
                }
                if (selected) {
                    this.addKeys(data);
                }
                this.panel.revalidate();
                this.panel.repaint();
            }
        }
        this.query(false);
    }

    void query(boolean force) {
        String simple;
        TokenBuilder tb = new TokenBuilder();
        Data data = this.gui.context.data();
        int cs = this.panel.getComponentCount();
        int c = 0;
        while (c < cs) {
            BaseXCombo com = (BaseXCombo)this.panel.getComponent(c);
            int k = com.getSelectedIndex();
            if (k > 0) {
                String key = com.getSelectedItem().toString();
                boolean attr = key.startsWith("@");
                if (!key.contains(":") && !attr) {
                    key = "*:" + key;
                }
                Component comp = this.panel.getComponent(c + 1);
                String pattern = "";
                String val1 = null;
                String val2 = null;
                if (comp instanceof BaseXTextField) {
                    val1 = ((BaseXTextField)comp).getText();
                    if (!val1.isEmpty()) {
                        if (val1.startsWith("\"")) {
                            val1 = val1.replaceAll("\"", "");
                            pattern = PATEX;
                        } else {
                            pattern = attr && data.meta.attrindex || !attr && data.meta.textindex ? PATSUB : PATEX;
                        }
                    }
                } else if (comp instanceof BaseXCombo) {
                    BaseXCombo combo = (BaseXCombo)comp;
                    if (combo.getSelectedIndex() != 0) {
                        val1 = combo.getSelectedItem().toString();
                        pattern = PATEX;
                    }
                } else if (comp instanceof BaseXDSlider) {
                    BaseXDSlider slider = (BaseXDSlider)comp;
                    if (slider.min != slider.totMin || slider.max != slider.totMax) {
                        double m = slider.min;
                        double n = slider.max;
                        val1 = (double)((long)m) == m ? Long.toString((long)m) : Double.toString(m);
                        val2 = (double)((long)n) == n ? Long.toString((long)n) : Double.toString(n);
                        pattern = PATNUM;
                    }
                }
                if (attr) {
                    key = "descendant-or-self::node()/" + key;
                    if (tb.size() == 0) {
                        tb.add("//*");
                    }
                    if (pattern.isEmpty()) {
                        pattern = PATSIMPLE;
                    }
                } else {
                    tb.add("//" + key);
                    key = "text()";
                }
                tb.addExt(pattern, key, val1, key, val2);
            }
            c += 2;
        }
        String qu = tb.toString();
        boolean root = this.gui.context.root();
        boolean rt = this.gui.gprop.is(GUIProp.FILTERRT);
        if (!(qu.isEmpty() || rt || root)) {
            qu = "." + qu;
        }
        if (!(simple = this.all.getText().trim()).isEmpty()) {
            simple = Find.find(simple, this.gui.context, rt);
            String string = qu = !qu.isEmpty() ? String.valueOf(simple) + " | " + qu : simple;
        }
        if (qu.isEmpty()) {
            String string = qu = rt || root ? "/" : ".";
        }
        if (!force && this.last.equals(qu)) {
            return;
        }
        this.last = qu;
        this.gui.xquery(qu, false);
    }

    private String[] entries(byte[][] key) {
        StringList sl = new StringList();
        sl.add(Util.info(Text.INFOENTRIES, key.length));
        byte[][] byArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] k = byArray[n2];
            sl.add(Token.string(k));
            ++n2;
        }
        sl.sort(true, true, 1);
        return sl.toArray();
    }
}

