/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.folder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBar;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.folder.FolderIterator;

public final class FolderView
extends View {
    boolean[] opened;
    int lineH;
    int focusedPos;
    private BufferedImage closedBox;
    private BufferedImage openedBox;
    private BufferedImage emptyBox;
    private final BaseXBar scroll;
    private int totalW;
    private int startY;
    private int treeH;
    private int boxW;
    private int boxMargin;

    public FolderView(ViewNotifier man) {
        super("folder", Text.HELPFOLDER, man);
        this.createBoxes();
        this.layout(new BorderLayout());
        this.scroll = new BaseXBar(this);
        this.add((Component)this.scroll, "East");
        new BaseXPopup(this, GUIConstants.POPUP);
    }

    @Override
    public void refreshInit() {
        this.scroll.pos(0);
        if (this.gui.context.data() == null) {
            this.opened = null;
        } else if (this.visible()) {
            this.refreshOpenedNodes();
            this.refreshHeight();
            this.repaint();
        }
    }

    private void refreshOpenedNodes() {
        Data data = this.gui.context.data();
        this.opened = new boolean[data.meta.size];
        int is = data.meta.size;
        int pre = 0;
        while (pre < is) {
            this.opened[pre] = data.parent(pre, data.kind(pre)) <= 0;
            ++pre;
        }
    }

    @Override
    public void refreshFocus() {
        this.repaint();
    }

    @Override
    public void refreshMark() {
        int pre = this.gui.context.focused;
        if (pre == -1) {
            return;
        }
        Data data = this.gui.context.data();
        int par = data.parent(pre, data.kind(pre));
        this.jumpTo(pre, par != -1 && !this.opened[par]);
        this.repaint();
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.startY = 0;
        this.scroll.pos(0);
        Nodes curr = this.gui.context.current();
        if (more && curr.size() != 0L) {
            this.jumpTo(curr.list[0], true);
        }
        this.refreshHeight();
        this.repaint();
    }

    @Override
    public void refreshLayout() {
        this.createBoxes();
        if (this.opened == null) {
            return;
        }
        this.refreshOpenedNodes();
        this.refreshHeight();
        this.repaint();
    }

    @Override
    public void refreshUpdate() {
        if (this.opened == null) {
            return;
        }
        Data data = this.gui.context.data();
        if (this.opened.length < data.meta.size) {
            this.opened = Arrays.copyOf(this.opened, data.meta.size);
        }
        this.startY = 0;
        this.scroll.pos(0);
        Nodes marked = this.gui.context.marked;
        if (marked.size() != 0L) {
            this.jumpTo(marked.list[0], true);
        }
        this.refreshHeight();
        this.repaint();
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWFOLDER);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWFOLDER, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    private void refreshHeight() {
        if (this.opened == null) {
            return;
        }
        this.treeH = new FolderIterator(this).height();
        this.scroll.height(this.treeH + 5);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.opened == null) {
            this.refreshInit();
            return;
        }
        super.paintComponent(g);
        if (this.opened == null) {
            return;
        }
        this.gui.painting = true;
        this.startY = -this.scroll.pos();
        this.totalW = this.getWidth() - (this.treeH > this.getHeight() ? this.scroll.getWidth() : 0);
        FolderIterator it = new FolderIterator(this, this.startY + 5, this.getHeight());
        Data data = this.gui.context.data();
        while (it.more()) {
            int kind = data.kind(it.pre);
            boolean elem = kind == 1 || kind == 0;
            int x = 8 + it.level * (this.lineH >> 1) + (elem ? this.lineH : this.boxW);
            this.drawString(g, it.pre, x, it.y + this.boxW);
        }
        this.gui.painting = false;
    }

    private void drawString(Graphics g, int pre, int x, int y) {
        Data data = this.gui.context.data();
        Nodes marked = this.gui.context.marked;
        int kind = data.kind(pre);
        boolean elem = kind == 1 || kind == 0;
        Color col = Color.black;
        Font fnt = GUIConstants.font;
        if (marked.find(pre) >= 0) {
            col = GUIConstants.colormark3;
            fnt = GUIConstants.bfont;
        }
        if (y < -this.lineH) {
            return;
        }
        g.setColor(GUIConstants.color2);
        g.drawLine(2, y + this.boxMargin - 1, this.totalW - 5, y + this.boxMargin - 1);
        byte[] name = ViewData.content(data, pre, false);
        int p = this.gui.context.focused;
        while (p > pre) {
            p = ViewData.parent(data, p);
        }
        if (pre == p) {
            g.setColor(GUIConstants.color3);
            g.fillRect(0, y - this.boxW - this.boxMargin, this.totalW, this.lineH + 1);
        }
        int xx = x;
        if (elem) {
            boolean large = this.gui.gprop.num(GUIProp.FONTSIZE) > 20;
            int yy = y - this.boxW - (large ? 6 : 3);
            BufferedImage box = this.opened[pre] ? this.openedBox : this.closedBox;
            g.drawImage(box, xx - this.lineH, yy, this);
        }
        g.setFont(fnt);
        g.setColor(col);
        int yy = y;
        int tw = this.totalW + 6;
        int fsz = this.gui.gprop.num(GUIProp.FONTSIZE);
        BaseXLayout.chopString(g, name, xx, yy - fsz, tw - xx - 10, fsz);
        if (this.gui.context.focused == pre) {
            g.setColor(GUIConstants.color5);
            g.drawRect(1, yy - this.boxW - this.boxMargin, this.totalW - 3, this.lineH + 1);
            g.drawRect(2, yy - this.boxW - this.boxMargin + 1, this.totalW - 5, this.lineH - 1);
        }
    }

    private boolean focus(int x, int y) {
        if (this.opened == null) {
            return false;
        }
        FolderIterator it = new FolderIterator(this, this.startY + 3, this.getHeight());
        Data data = this.gui.context.data();
        while (it.more()) {
            int xx;
            if (y <= it.y || y > it.y + this.lineH) continue;
            Cursor c = GUIConstants.CURSORARROW;
            int kind = data.kind(it.pre);
            if ((kind == 1 || kind == 0) && x > (xx = 8 + it.level * (this.lineH >> 2) + this.lineH) - 20 && x < xx) {
                c = GUIConstants.CURSORHAND;
            }
            this.gui.cursor(c);
            this.gui.notify.focus(it.pre, this);
            this.repaint();
            return true;
        }
        return false;
    }

    private void jumpTo(int pre, boolean open) {
        if (this.getWidth() == 0 || !this.visible()) {
            return;
        }
        if (open) {
            int p = pre;
            while (p > 0) {
                this.opened[p] = true;
                p = ViewData.parent(this.gui.context.data(), p);
            }
            this.refreshHeight();
        }
        FolderIterator it = new FolderIterator(this);
        while (it.more() && pre != it.pre) {
        }
        int y = -it.y;
        int h = this.getHeight();
        if (y > this.startY || y + h < this.startY + this.lineH) {
            this.startY = Math.min(0, Math.max(-this.treeH + h - 5, y + this.lineH));
            this.scroll.pos(-this.startY);
        }
    }

    private void createBoxes() {
        int s = this.gui.gprop.num(GUIProp.FONTSIZE);
        this.boxMargin = s >> 2;
        this.lineH = s + this.boxMargin;
        this.boxW = s - this.boxMargin;
        int sp = Math.max(1, s >> 4);
        this.emptyBox = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        Graphics2D g = this.emptyBox.createGraphics();
        this.smooth(g);
        g.setColor(GUIConstants.color5);
        g.fillOval((this.boxW >> 2) - 1, (this.boxW >> 2) + 1, this.boxW >> 1, this.boxW >> 1);
        g.setColor(GUIConstants.color4);
        g.fillOval((this.boxW >> 2) - 2, this.boxW >> 2, this.boxW >> 1, this.boxW >> 1);
        this.openedBox = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        g = this.openedBox.createGraphics();
        this.smooth(g);
        int[] nArray = new int[3];
        nArray[1] = this.boxW;
        nArray[2] = this.boxW >> 1;
        Polygon p = new Polygon(nArray, new int[]{this.boxW - sp >> 1, this.boxW - sp >> 1, this.boxW}, 3);
        p.translate(0, -1);
        g.setColor(GUIConstants.color5);
        g.fillPolygon(p);
        p.translate(-1, -1);
        g.setColor(GUIConstants.color4);
        g.fillPolygon(p);
        this.closedBox = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        g = this.closedBox.createGraphics();
        this.smooth(g);
        int[] nArray2 = new int[3];
        nArray2[1] = this.boxW >> 1;
        nArray2[2] = this.boxW;
        p = new Polygon(new int[]{this.boxW - sp >> 1, this.boxW, this.boxW - sp >> 1}, nArray2, 3);
        p.translate(-1, 1);
        g.setColor(GUIConstants.color5);
        g.fillPolygon(p);
        p.translate(-1, -1);
        g.setColor(GUIConstants.color4);
        g.fillPolygon(p);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        super.mouseMoved(e);
        this.focus(e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.gui.updating || this.opened == null) {
            return;
        }
        super.mousePressed(e);
        if (!this.focus(e.getX(), e.getY())) {
            return;
        }
        Nodes marked = this.gui.context.marked;
        if (e.getClickCount() == 2) {
            this.gui.notify.context(marked, false, null);
        } else if (e.isShiftDown()) {
            this.gui.notify.mark(1, null);
        } else if (BaseXKeys.sc(e)) {
            this.gui.notify.mark(2, null);
        } else if (!SwingUtilities.isLeftMouseButton(e) || this.getCursor() != GUIConstants.CURSORHAND) {
            if (!marked.contains(this.gui.context.focused)) {
                this.gui.notify.mark(0, null);
            }
        } else {
            int n = this.gui.context.focused;
            this.opened[n] = this.opened[n] ^ true;
            this.refreshHeight();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left || this.gui.updating || this.opened == null) {
            return;
        }
        super.mouseDragged(e);
        if (this.focus(e.getX(), e.getY())) {
            this.gui.notify.mark(1, null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.gui.updating) {
            return;
        }
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * 20);
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int focus;
        if (this.gui.updating || this.opened == null) {
            return;
        }
        super.keyPressed(e);
        int n = focus = this.focusedPos == -1 ? 0 : this.focusedPos;
        if (this.gui.context.focused == -1) {
            this.gui.context.focused = 0;
        }
        int focusPre = this.gui.context.focused;
        Data data = this.gui.context.data();
        int kind = data.kind(focusPre);
        boolean right = BaseXKeys.NEXT.is(e);
        boolean down = BaseXKeys.NEXTLINE.is(e);
        boolean up = BaseXKeys.PREVLINE.is(e);
        if (right || BaseXKeys.PREV.is(e)) {
            if (e.isShiftDown()) {
                this.opened[focusPre] = right;
                int s = data.meta.size;
                int pre = focusPre + 1;
                while (pre != s && data.parent(pre, data.kind(pre)) >= focusPre) {
                    this.opened[pre] = right;
                    ++pre;
                }
                this.refreshHeight();
                this.repaint();
                return;
            }
            if (right ^ this.opened[focusPre] && (!ViewData.leaf(this.gui.gprop, data, focusPre) || data.attSize(focusPre, kind) > 1)) {
                this.opened[focusPre] = right;
                this.refreshHeight();
                this.repaint();
            } else if (right) {
                down = true;
            } else {
                up = true;
            }
        }
        if (down) {
            focus = Math.min(data.meta.size - 1, focus + 1);
        } else if (up) {
            focus = Math.max(0, focus - 1);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            focus = Math.min(data.meta.size - 1, focus + this.getHeight() / this.lineH);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            focus = Math.max(0, focus - this.getHeight() / this.lineH);
        } else if (BaseXKeys.TEXTSTART.is(e)) {
            focus = 0;
        } else if (BaseXKeys.TEXTEND.is(e)) {
            focus = data.meta.size - 1;
        }
        if (focus == this.focusedPos) {
            return;
        }
        this.gui.context.focused = -1;
        Nodes curr = this.gui.context.current();
        int pre = curr.list[0];
        FolderIterator it = new FolderIterator(this);
        while (it.more() && focus-- != 0) {
            pre = it.pre;
        }
        if (pre == curr.list[0] && down) {
            ++pre;
        }
        this.gui.notify.focus(pre, this);
        this.jumpTo(pre, false);
        this.repaint();
    }
}

