/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXBar;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.table.TableData;
import org.basex.gui.view.table.TableIterator;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

final class TableContent
extends BaseXBack {
    private final BaseXBar scroll;
    private final TableData tdata;
    private final GUI gui;
    String focusedString;

    TableContent(TableData d, BaseXBar scr) {
        this.scroll = scr;
        this.tdata = d;
        this.gui = scr.gui;
        this.layout(new BorderLayout());
        this.mode(this.gui.gprop.is(GUIProp.GRADIENT) ? GUIConstants.Fill.GRADIENT : GUIConstants.Fill.NONE);
        this.add((Component)this.scroll, "East");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tdata.rows == null) {
            return;
        }
        this.gui.painting = true;
        g.setFont(GUIConstants.font);
        int w = this.getWidth() - this.scroll.getWidth();
        int h = this.getHeight();
        int fsz = this.gui.gprop.num(GUIProp.FONTSIZE);
        Context context = this.tdata.context;
        Data data = context.data();
        int focus = this.gui.context.focused;
        int rfocus = this.tdata.getRoot(data, focus);
        int mpos = 0;
        int nCols = this.tdata.cols.length;
        int nRows = this.tdata.rows.size();
        int rowH = this.tdata.rowH;
        TableIterator ti = new TableIterator(data, this.tdata);
        TokenBuilder[] tb = new TokenBuilder[nCols];
        int i = 0;
        while (i < nCols) {
            tb[i] = new TokenBuilder();
            ++i;
        }
        this.focusedString = null;
        Nodes marked = context.marked;
        int l = this.scroll.pos() / rowH - 1;
        int posY = -this.scroll.pos() + l * rowH;
        while (++l < nRows && marked != null) {
            int col;
            boolean rf;
            if (posY > h || l >= this.tdata.rows.size()) break;
            posY += rowH;
            int pre = this.tdata.rows.get(l);
            while ((long)mpos < marked.size() && marked.list[mpos] < pre) {
                ++mpos;
            }
            g.setColor(GUIConstants.color3);
            g.drawLine(0, posY + rowH - 1, w, posY + rowH - 1);
            g.setColor(Color.white);
            g.drawLine(0, posY + rowH, w, posY + rowH);
            boolean rm = (long)mpos < marked.size() && marked.list[mpos] == pre;
            boolean bl = rf = pre == rfocus;
            int n = rm ? (rf ? 5 : 4) : (col = 3);
            if (rm || rf) {
                g.setColor(GUIConstants.color(col));
                g.fillRect(0, posY - 1, w, rowH);
                g.setColor(GUIConstants.color(col + 4));
                g.drawLine(0, posY - 1, w, posY - 1);
            }
            g.setColor(Color.black);
            if (rowH < fsz) continue;
            ti.init(pre);
            int fcol = -1;
            while (ti.more()) {
                int c = ti.col;
                if (ti.pre == focus || data.parent(ti.pre, data.kind(ti.pre)) == focus) {
                    fcol = c;
                }
                if (tb[c].size() >= 100) continue;
                if (tb[c].size() != 0) {
                    tb[c].add("; ");
                }
                tb[c].add(data.text(ti.pre, ti.text));
            }
            TokenBuilder[] tokenBuilderArray = tb;
            int n2 = tb.length;
            int n3 = 0;
            while (n3 < n2) {
                TokenBuilder t = tokenBuilderArray[n3];
                if (t.size() > 100) {
                    t.add("...");
                }
                ++n3;
            }
            byte[] focusStr = null;
            int fx = -1;
            double x = 1.0;
            int c = 0;
            while (c < nCols) {
                double cw = (double)w * this.tdata.cols[c].width;
                double ce = x + cw;
                if (ce != 0.0) {
                    byte[] str;
                    byte[] byArray = str = tb[c].size() != 0 ? tb[c].finish() : null;
                    if (str != null) {
                        if ((double)this.tdata.mouseX > x && (double)this.tdata.mouseX < ce || fcol == c) {
                            fx = (int)x;
                            focusStr = str;
                        }
                        BaseXLayout.chopString(g, str, (int)x + 1, posY + 2, (int)cw - 4, fsz);
                        tb[c].reset();
                    }
                }
                x = ce;
                ++c;
            }
            if (!rf && fcol == -1 || focusStr == null) continue;
            int sw = BaseXLayout.width(g, focusStr) + 8;
            if (fx > w - sw - 2) {
                fx = w - sw - 2;
            }
            g.setColor(GUIConstants.color(col + 2));
            g.fillRect(fx - 2, posY, sw, rowH - 1);
            g.setColor(Color.black);
            BaseXLayout.chopString(g, focusStr, fx + 1, posY + 2, sw, fsz);
            this.focusedString = Token.string(focusStr);
            int i2 = this.focusedString.indexOf("; ");
            if (i2 == -1) continue;
            this.focusedString = this.focusedString.substring(0, i2);
        }
        this.gui.painting = false;
    }
}

