/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.IOException;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class DocIndex
implements Index {
    private final Data data;
    private IntList docs;
    private byte[][] paths;
    private int[] order;

    public DocIndex(Data d) {
        this.data = d;
    }

    public synchronized boolean read(DataInput in) throws IOException {
        this.docs = in.readDiffs();
        return true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeDiffs(this.docs());
    }

    public synchronized IntList docs() {
        if (this.docs == null) {
            this.initDocs();
        }
        return this.docs;
    }

    public void insert(int pre, Data d) {
        int dsize = d.meta.size;
        IntList pres = new IntList();
        int dpre = 0;
        while (dpre < dsize) {
            int k = d.kind(dpre);
            if (k == 0) {
                pres.add(pre + dpre);
            }
            dpre += d.size(dpre, k);
        }
        IntList il = this.docs();
        int i = il.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        }
        il.insert(i, pres.toArray());
        il.move(dsize, i + pres.size());
        this.update();
    }

    public void delete(int pre, int size) {
        IntList il = this.docs();
        int i = il.sortedIndexOf(pre);
        if (i < 0) {
            i = -i - 1;
        } else {
            il.delete(i);
        }
        il.move(-size, i);
        this.update();
    }

    public void replace(int pre, Data d) {
        this.delete(pre, d.meta.size);
        this.insert(pre, d);
    }

    public synchronized void update() {
        this.paths = null;
        this.order = null;
    }

    public synchronized IntList docs(String path) {
        String pth = MetaData.normPath(path);
        if (pth == null || this.data.empty()) {
            return new IntList(0);
        }
        IntList doc = this.docs();
        if (pth.isEmpty()) {
            return doc;
        }
        if (this.paths == null) {
            this.initPaths();
        }
        byte[] exct = Token.concat(Token.SLASH, Prop.WIN ? Token.lc(Token.token(pth)) : Token.token(pth));
        byte[] pref = Token.concat(exct, Token.SLASH);
        IntList il = new IntList();
        int p = this.find(exct);
        while (p < this.paths.length) {
            if (Token.eq(this.paths[p], exct) || Token.startsWith(this.paths[p], pref)) {
                il.add(doc.get(this.order[p]));
            }
            ++p;
        }
        return il.sort();
    }

    public synchronized int doc(String path) {
        String pth = MetaData.normPath(path);
        if (pth == null || pth.isEmpty() || this.data.empty()) {
            return -1;
        }
        if (this.paths == null) {
            this.initPaths();
        }
        byte[] exct = Token.concat(Token.SLASH, Prop.WIN ? Token.lc(Token.token(pth)) : Token.token(pth));
        int p = this.find(exct);
        return p < this.paths.length && Token.eq(this.paths[p], exct) ? this.docs.get(this.order[p]) : -1;
    }

    public synchronized TokenList files(String path) {
        TokenList tl = new TokenList();
        String np = MetaData.normPath(path);
        if (np == null) {
            return tl;
        }
        String exct = Prop.WIN ? np.toLowerCase() : np;
        String pref = String.valueOf(exct) + '/';
        for (String f : this.data.meta.binaries().descendants()) {
            String lc;
            String string = lc = Prop.WIN ? f.toLowerCase() : f;
            if (!exct.isEmpty() && !lc.equals(exct) && !lc.startsWith(pref)) continue;
            tl.add(f);
        }
        return tl.sort(!Prop.WIN);
    }

    private int find(byte[] v) {
        int l = 0;
        int h = this.order.length - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int c = Token.diff(this.paths[m], v);
            if (c == 0) {
                while (m > 0 && Token.eq(this.paths[m - 1], v)) {
                    --m;
                }
                return m;
            }
            if (c < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return l;
    }

    private synchronized void initDocs() {
        this.update();
        this.docs = new IntList();
        int is = this.data.meta.size;
        int i = 0;
        while (i < is) {
            this.docs.add(i);
            i += this.data.size(i, 0);
        }
        this.data.meta.dirty = true;
    }

    private synchronized void initPaths() {
        IntList doc = this.docs();
        int ds = doc.size();
        this.paths = new byte[ds][];
        int d = 0;
        while (d < ds) {
            byte[] txt = this.data.text(doc.get(d), true);
            this.paths[d] = Token.concat(Token.SLASH, Prop.WIN ? Token.lc(txt) : txt);
            ++d;
        }
        this.order = Array.createOrder(this.paths, false, true);
    }

    @Override
    public void close() {
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public int count(IndexToken token) {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public byte[] info() {
        throw Util.notexpected(new Object[0]);
    }
}

