/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Array;
import org.basex.util.list.IntList;

public class IdPreMap {
    private int baseid;
    private int[] pres;
    private int[] fids;
    private int[] nids;
    private int[] incs;
    private int[] oids;
    private int rows;

    public IdPreMap(int id) {
        this.baseid = id;
        this.pres = new int[1];
        this.fids = new int[this.pres.length];
        this.nids = new int[this.pres.length];
        this.incs = new int[this.pres.length];
        this.oids = new int[this.pres.length];
    }

    public IdPreMap(File f) throws IOException {
        DataInput in = new DataInput(f);
        try {
            this.baseid = in.readNum();
            this.rows = in.readNum();
            this.pres = in.readNums();
            this.fids = in.readNums();
            this.nids = in.readNums();
            this.incs = in.readNums();
            this.oids = in.readNums();
        }
        finally {
            in.close();
        }
    }

    public void write(File f) throws IOException {
        DataOutput out = new DataOutput(f);
        try {
            out.writeNum(this.baseid);
            out.writeNum(this.rows);
            out.writeNums(this.pres);
            out.writeNums(this.fids);
            out.writeNums(this.nids);
            out.writeNums(this.incs);
            out.writeNums(this.oids);
        }
        finally {
            out.close();
        }
    }

    public int pre(int id) {
        int i;
        if (this.rows == 0 || id < this.pres[0]) {
            return id;
        }
        if (id > this.baseid) {
            i = 0;
            while (i < this.rows) {
                if (this.fids[i] == id) {
                    return this.pres[i];
                }
                if (this.fids[i] < id && id <= this.nids[i]) {
                    return this.pres[i] + id - this.fids[i];
                }
                ++i;
            }
        }
        return id + this.incs[(i = this.sortedLastIndexOf(this.oids, id)) < 0 ? -i - 2 : i];
    }

    public int[] pre(int[] ids) {
        return this.pre(ids, 0, ids.length);
    }

    public int[] pre(int[] ids, int off, int len) {
        IntList p = new IntList(ids.length);
        int i = off;
        while (i < len) {
            p.add(this.pre(ids[i]));
            ++i;
        }
        return p.sort().toArray();
    }

    public void insert(int pre, int id, int c) {
        if (this.rows == 0 && pre == id && id == this.baseid + 1) {
            this.baseid += c;
            return;
        }
        int pos = 0;
        int inc = c;
        int oid = pre;
        if (this.rows > 0) {
            pos = Arrays.binarySearch(this.pres, 0, this.rows, pre);
            if (pos < 0) {
                if ((pos = -pos - 1) != 0) {
                    int prev = pos - 1;
                    int prevpre = this.pres[prev];
                    int prevcnt = this.nids[prev] - this.fids[prev] + 1;
                    if (pre < prevpre + prevcnt) {
                        int split = pre - prevpre;
                        int fid = this.fids[prev] + split;
                        this.add(pos, pre, fid, this.nids[prev], this.incs[prev], this.oids[prev]);
                        this.nids[prev] = fid - 1;
                        int n = prev;
                        this.incs[n] = this.incs[n] - (prevcnt - split);
                        oid = this.oids[prev];
                        inc += this.incs[prev];
                    } else {
                        oid = pre - this.incs[prev];
                        inc += this.incs[prev];
                    }
                }
            } else if (pos > 0) {
                oid = this.oids[pos];
                inc += this.incs[pos - 1];
            }
            int k = pos;
            while (k < this.rows) {
                int n = k;
                this.pres[n] = this.pres[n] + c;
                int n2 = k++;
                this.incs[n2] = this.incs[n2] + c;
            }
        }
        this.add(pos, pre, id, id + c - 1, inc, oid);
    }

    public void delete(int pre, int id) {
        this.delete(pre, id, -1);
    }

    public void delete(int pre, int id, int c) {
        if (this.rows == 0 && pre == id && id - c == this.baseid + 1) {
            this.baseid += c;
            return;
        }
        int inc = c;
        int oid = id;
        if (this.rows > 0) {
            int s;
            int min2;
            int max2;
            boolean found2;
            int pre1 = pre;
            int pre2 = pre - c - 1;
            int i1 = this.findPre(pre1);
            int i2 = -c > 1 ? this.findPre(pre2) : i1;
            boolean found1 = i1 >= 0;
            boolean bl = found2 = i2 >= 0;
            if (!found1) {
                i1 = -i1 - 1;
            }
            if (!found2) {
                i2 = -i2 - 1;
            }
            if (i1 >= this.rows) {
                this.add(i1, pre, -1, -1, this.incs[i1 - 1] + inc, oid);
                return;
            }
            int min1 = this.pres[i1];
            int max1 = this.pres[i1] + this.nids[i1] - this.fids[i1];
            if (i2 >= this.rows) {
                min2 = max2 = pre2 + 1;
            } else {
                min2 = this.pres[i2];
                max2 = this.pres[i2] + this.nids[i2] - this.fids[i2];
            }
            int k = found2 ? i2 + 1 : i2;
            while (k < this.rows) {
                int n = k;
                this.pres[n] = this.pres[n] + c;
                int n2 = k++;
                this.incs[n2] = this.incs[n2] + c;
            }
            if (i1 == i2) {
                if (pre1 <= min1) {
                    if (pre2 == max2) {
                        if (i2 + 1 < this.rows && this.pres[i2 + 1] == pre) {
                            this.remove(i1, i2);
                        } else {
                            int n = i2;
                            this.incs[n] = this.incs[n] + c;
                            this.pres[i2] = pre;
                            this.fids[i2] = -1;
                            this.nids[i2] = -1;
                        }
                    } else if (min2 <= pre2 && pre2 < max2) {
                        int n = i2;
                        this.incs[n] = this.incs[n] + c;
                        this.pres[i2] = pre;
                        int n3 = i2;
                        this.fids[n3] = this.fids[n3] + (pre2 - min2 + 1);
                    } else if (pre2 < min2 - 1) {
                        this.add(i1, pre, -1, -1, i1 > 0 ? this.incs[i1 - 1] + c : c, oid);
                    }
                } else if (min1 < pre1) {
                    if (min2 < pre2 && pre2 < max2) {
                        int fid = this.fids[i2] + pre2 - min2 + 1;
                        this.add(i2 + 1, pre2 + c + 1, fid, this.nids[i2], this.incs[i1] + c, this.oids[i2]);
                    }
                    s = max1 - pre1 + 1;
                    int n = i1;
                    this.nids[n] = this.nids[n] - s;
                    int n4 = i1;
                    this.incs[n4] = this.incs[n4] - s;
                }
            } else if (i1 < i2) {
                if (pre1 <= min1) {
                    if (pre2 == max2) {
                        if (i2 + 1 < this.rows && this.pres[i2 + 1] == pre) {
                            this.remove(i1, i2);
                        } else {
                            int n = i2;
                            this.incs[n] = this.incs[n] + c;
                            this.pres[i2] = pre;
                            this.fids[i2] = -1;
                            this.nids[i2] = -1;
                            this.remove(i1, i2 - 1);
                        }
                    } else if (min2 <= pre2 && pre2 < max2) {
                        int n = i2;
                        this.incs[n] = this.incs[n] + c;
                        this.pres[i2] = pre;
                        int n5 = i2;
                        this.fids[n5] = this.fids[n5] + (pre2 - min2 + 1);
                        this.remove(i1, i2 - 1);
                    } else if (pre2 < min2) {
                        if (i2 < this.rows && this.pres[i2] == pre) {
                            this.remove(i1, --i2);
                        } else {
                            int n = --i2;
                            this.incs[n] = this.incs[n] + c;
                            this.pres[i2] = pre;
                            this.fids[i2] = -1;
                            this.nids[i2] = -1;
                            this.remove(i1, i2 - 1);
                        }
                    }
                } else if (min1 < pre1) {
                    if (pre2 == max2) {
                        oid = this.oids[i2];
                        this.remove(i1 + 1, i2);
                        int n = i1;
                        this.nids[n] = this.nids[n] - (max1 - pre1 + 1);
                        this.incs[i1] = inc += this.incs[i2];
                        this.oids[i1] = oid;
                    } else if (min2 <= pre2 && pre2 < max2) {
                        int n = i2;
                        this.fids[n] = this.fids[n] + (pre2 - min2 + 1);
                        int n6 = i2;
                        this.incs[n6] = this.incs[n6] + c;
                        this.pres[i2] = pre;
                        this.remove(i1 + 1, i2 - 1);
                        s = max1 - pre1 + 1;
                        int n7 = i1;
                        this.nids[n7] = this.nids[n7] - s;
                        int n8 = i1;
                        this.incs[n8] = this.incs[n8] - s;
                    } else if (pre2 < min2) {
                        this.incs[i1] = this.incs[i2 - 1] + c;
                        this.remove(i1 + 1, i2 - 1);
                        s = max1 - pre1 + 1;
                        int n = i1;
                        this.nids[n] = this.nids[n] - s;
                    }
                }
            }
        } else {
            this.add(0, pre, -1, -1, inc, oid);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("pres, fids, nids, incs, oids");
        int i = 0;
        while (i < this.rows) {
            b.append('\n');
            b.append(this.pres[i]);
            b.append(", ");
            b.append(this.fids[i]);
            b.append(", ");
            b.append(this.nids[i]);
            b.append(", ");
            b.append(this.incs[i]);
            b.append(", ");
            b.append(this.oids[i]);
            ++i;
        }
        return b.toString();
    }

    public int size() {
        return this.rows;
    }

    private int findPre(int pre) {
        int low = 0;
        int high = this.rows - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValMin = this.pres[mid];
            int midValMax = midValMin + this.nids[mid] - this.fids[mid];
            if (midValMax < pre) {
                low = mid + 1;
                continue;
            }
            if (midValMin > pre) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int sortedLastIndexOf(int[] a, int e) {
        int i = Arrays.binarySearch(a, 0, this.rows, e);
        if (i >= 0) {
            while (++i < this.rows && a[i] == e) {
            }
            return i - 1;
        }
        return i;
    }

    private void add(int i, int pre, int fid, int nid, int inc, int oid) {
        if (this.rows == this.pres.length) {
            int s = Array.newSize(this.rows);
            this.pres = Arrays.copyOf(this.pres, s);
            this.fids = Arrays.copyOf(this.fids, s);
            this.nids = Arrays.copyOf(this.nids, s);
            this.incs = Arrays.copyOf(this.incs, s);
            this.oids = Arrays.copyOf(this.oids, s);
        }
        if (i < this.rows) {
            System.arraycopy(this.pres, i, this.pres, i + 1, this.rows - i);
            System.arraycopy(this.fids, i, this.fids, i + 1, this.rows - i);
            System.arraycopy(this.nids, i, this.nids, i + 1, this.rows - i);
            System.arraycopy(this.incs, i, this.incs, i + 1, this.rows - i);
            System.arraycopy(this.oids, i, this.oids, i + 1, this.rows - i);
        }
        this.pres[i] = pre;
        this.fids[i] = fid;
        this.nids[i] = nid;
        this.incs[i] = inc;
        this.oids[i] = oid;
        ++this.rows;
    }

    private void remove(int s, int e) {
        if (s <= e) {
            System.arraycopy(this.pres, e + 1, this.pres, s, this.rows - (e + 1));
            System.arraycopy(this.fids, e + 1, this.fids, s, this.rows - (e + 1));
            System.arraycopy(this.nids, e + 1, this.nids, s, this.rows - (e + 1));
            System.arraycopy(this.incs, e + 1, this.incs, s, this.rows - (e + 1));
            System.arraycopy(this.oids, e + 1, this.oids, s, this.rows - (e + 1));
            this.rows -= e - s + 1;
        }
    }
}

