/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.path;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.serial.Serializer;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ObjList;

public final class PathNode {
    public final short name;
    public final byte kind;
    public final PathNode par;
    public int size;
    PathNode[] ch;

    PathNode(int t, byte k, PathNode p) {
        this.ch = new PathNode[0];
        this.size = 1;
        this.name = (short)t;
        this.kind = k;
        this.par = p;
    }

    PathNode(DataInput in, PathNode p) throws IOException {
        this.name = (short)in.readNum();
        this.kind = (byte)in.read();
        this.size = in.readNum();
        this.ch = new PathNode[in.readNum()];
        in.readDouble();
        this.par = p;
        int i = 0;
        while (i < this.ch.length) {
            this.ch[i] = new PathNode(in, this);
            ++i;
        }
    }

    PathNode index(int n, byte k) {
        PathNode[] pathNodeArray = this.ch;
        int n2 = this.ch.length;
        int n3 = 0;
        while (n3 < n2) {
            PathNode c = pathNodeArray[n3];
            if (c.kind == k && c.name == n) {
                ++c.size;
                return c;
            }
            ++n3;
        }
        PathNode pn = new PathNode(n, k, this);
        int cs = this.ch.length;
        PathNode[] tmp = new PathNode[cs + 1];
        System.arraycopy(this.ch, 0, tmp, 0, cs);
        tmp[cs] = pn;
        this.ch = tmp;
        return pn;
    }

    void write(DataOutput out) throws IOException {
        out.writeNum(this.name);
        out.write1(this.kind);
        out.writeNum(this.size);
        out.writeNum(this.ch.length);
        out.writeDouble(0.0);
        PathNode[] pathNodeArray = this.ch;
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            PathNode c = pathNodeArray[n2];
            c.write(out);
            ++n2;
        }
    }

    void addDesc(ObjList<PathNode> nodes) {
        nodes.add(this);
        PathNode[] pathNodeArray = this.ch;
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            PathNode n3 = pathNodeArray[n2];
            n3.addDesc(nodes);
            ++n2;
        }
    }

    void addDesc(ObjList<PathNode> nodes, int n, int k) {
        if (n == this.name && k == this.kind) {
            nodes.add(this);
        }
        PathNode[] pathNodeArray = this.ch;
        int n2 = this.ch.length;
        int n3 = 0;
        while (n3 < n2) {
            PathNode pn = pathNodeArray[n3];
            pn.addDesc(nodes, n, k);
            ++n3;
        }
    }

    public byte[] token(Data data) {
        switch (this.kind) {
            case 1: {
                return data.tagindex.key(this.name);
            }
            case 3: {
                return Token.concat(DataText.ATT, data.atnindex.key(this.name));
            }
            case 2: {
                return DataText.TEXT;
            }
            case 4: {
                return DataText.COMM;
            }
            case 5: {
                return DataText.PI;
            }
        }
        return Token.EMPTY;
    }

    public int level() {
        PathNode pn = this.par;
        int c = 0;
        while (pn != null) {
            pn = pn.par;
            ++c;
        }
        return c;
    }

    byte[] info(Data data, int l) {
        TokenBuilder tb = new TokenBuilder();
        if (l != 0) {
            tb.add(Text.NL);
        }
        int i = 0;
        while (i < l << 1) {
            tb.add(32);
            ++i;
        }
        switch (this.kind) {
            case 0: {
                tb.add(DataText.DOC);
                break;
            }
            case 1: {
                tb.add(data.tagindex.key(this.name));
                break;
            }
            case 2: {
                tb.add(DataText.TEXT);
                break;
            }
            case 3: {
                tb.add(DataText.ATT);
                tb.add(data.atnindex.key(this.name));
                break;
            }
            case 4: {
                tb.add(DataText.COMM);
                break;
            }
            case 5: {
                tb.add(DataText.PI);
            }
        }
        tb.add(" " + this.size + "x");
        PathNode[] pathNodeArray = this.ch;
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            PathNode p = pathNodeArray[n2];
            tb.add(p.info(data, l + 1));
            ++n2;
        }
        return tb.finish();
    }

    void plan(Data data, Serializer ser) throws IOException {
        ser.openElement(DataText.NODE, (byte[][])new byte[][]{DataText.KIND, DataText.TABLEKINDS[this.kind]});
        if (this.kind == 1) {
            ser.attribute(DataText.NAME, data.tagindex.key(this.name));
        } else if (this.kind == 3) {
            ser.attribute(DataText.NAME, Token.concat(DataText.ATT, data.atnindex.key(this.name)));
        }
        ser.text(Token.token(this.size));
        PathNode[] pathNodeArray = this.ch;
        int n = this.ch.length;
        int n2 = 0;
        while (n2 < n) {
            PathNode p = pathNodeArray[n2];
            p.plan(data, ser);
            ++n2;
        }
        ser.closeElement();
    }
}

