/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.util.TokenBuilder;
import org.basex.util.list.ObjList;
import org.basex.util.list.StringList;
import org.xml.sax.InputSource;

public final class IOFile
extends IO {
    private final File file;
    private InputStream is;
    private long len = -1L;
    ZipEntry zip;

    public IOFile(String f) {
        this(new File(f));
    }

    public IOFile(File f) {
        super(new PathList().create(f.getAbsolutePath()));
        this.file = f;
    }

    public IOFile(String dir, String n) {
        this(new File(dir, n));
    }

    public IOFile(File dir, String n) {
        this(new File(dir, n));
    }

    public IOFile(IOFile dir, String n) {
        this(new File(dir.file, n));
    }

    public File file() {
        return this.file;
    }

    @Override
    public byte[] read() throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(this.file));
        byte[] cont = new byte[(int)this.file.length()];
        try {
            dis.readFully(cont);
        }
        finally {
            dis.close();
        }
        return cont;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDir() {
        return this.file.isDirectory();
    }

    @Override
    public long date() {
        return this.file.lastModified();
    }

    @Override
    public long length() {
        if (this.len == -1L) {
            this.len = this.file.length();
        }
        return this.len;
    }

    @Override
    public boolean more() throws IOException {
        if (this.path.toLowerCase().endsWith(".gz")) {
            if (this.is == null) {
                this.is = new GZIPInputStream(new FileInputStream(this.file));
            } else {
                this.is.close();
                this.is = null;
            }
            return this.is != null;
        }
        if (this.is instanceof ZipInputStream || this.isArchive()) {
            block6: {
                if (this.is == null) {
                    this.is = new ZipInputStream(new FileInputStream(this.file)){

                        @Override
                        public void close() throws IOException {
                            if (IOFile.this.zip == null) {
                                super.close();
                            }
                        }
                    };
                }
                do {
                    this.zip = ((ZipInputStream)this.is).getNextEntry();
                    if (this.zip == null) break block6;
                    this.len = this.zip.getSize();
                    this.init(this.zip.getName());
                } while (!this.path.toLowerCase().endsWith(".xml") || this.zip.isDirectory());
                return true;
            }
            this.is.close();
            this.is = null;
            return false;
        }
        return this.more ^= true;
    }

    @Override
    public boolean isArchive() {
        return this.isSuffix(ZIPSUFFIXES);
    }

    @Override
    public boolean isXML() {
        return this.isSuffix(XMLSUFFIXES);
    }

    private boolean isSuffix(String[] suffixes) {
        int i = this.path.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String suf = this.path.substring(i).toLowerCase();
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String z = stringArray[n2];
            if (suf.equals(z)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public InputSource inputSource() {
        return this.is == null ? new InputSource(this.path) : new InputSource(this.is);
    }

    @Override
    public BufferInput buffer() throws IOException {
        if (this.is == null) {
            return new BufferInput(this.file);
        }
        BufferInput in = new BufferInput(this.is);
        if (this.zip != null && this.zip.getSize() != -1L) {
            in.length(this.zip.getSize());
        }
        return in;
    }

    @Override
    public IOFile merge(String f) {
        return f.contains(":") ? new IOFile(f) : new IOFile(this.dir(), f);
    }

    public boolean md() {
        return !this.file.exists() && this.file.mkdirs();
    }

    @Override
    public String dir() {
        return this.isDir() ? this.path : this.path.substring(0, this.path.lastIndexOf(47) + 1);
    }

    public IOFile[] children() {
        return this.children(".*");
    }

    public IOFile[] children(String pattern) {
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return new IOFile[0];
        }
        ObjList<IOFile> io = new ObjList<IOFile>(ch.length);
        Pattern p = Pattern.compile(pattern, Prop.WIN ? 2 : 0);
        File[] fileArray = ch;
        int n = ch.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (p.matcher(f.getName()).matches()) {
                io.add(new IOFile(f));
            }
            ++n2;
        }
        return io.toArray(new IOFile[io.size()]);
    }

    public synchronized StringList descendants() {
        StringList files = new StringList();
        File[] ch = this.file.listFiles();
        if (ch == null) {
            return files;
        }
        if (this.exists()) {
            this.add(this, files, this.path().length() + 1);
        }
        return files;
    }

    private void add(IOFile io, StringList files, int off) {
        if (io.isDir()) {
            IOFile[] iOFileArray = io.children();
            int n = iOFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile f = iOFileArray[n2];
                this.add(f, files, off);
                ++n2;
            }
        } else {
            files.add(io.path().substring(off).replace('\\', '/'));
        }
    }

    public void write(byte[] c) throws IOException {
        FileOutputStream out = new FileOutputStream(this.path);
        try {
            out.write(c);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean delete() {
        boolean ok = true;
        if (this.isDir()) {
            IOFile[] iOFileArray = this.children();
            int n = iOFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IOFile ch = iOFileArray[n2];
                ok &= ch.delete();
                ++n2;
            }
        }
        return this.file.delete() && ok;
    }

    public boolean rename(IOFile trg) {
        return this.file.renameTo(trg.file);
    }

    @Override
    public String url() {
        TokenBuilder tb = new TokenBuilder("file:");
        if (!this.path.startsWith("/")) {
            tb.add(47);
        }
        int p = 0;
        while (p < this.path.length()) {
            char ch = this.path.charAt(p);
            if (ch == ' ') {
                tb.add("%20");
            } else {
                tb.add(ch);
            }
            ++p;
        }
        return tb.toString();
    }

    public static String regex(String glob) {
        return IOFile.regex(glob, true);
    }

    public static String regex(String glob, boolean sub) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = glob.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String g = stringArray[n2];
            boolean suf = false;
            String gl = g.trim();
            if (sb.length() != 0) {
                if (!suf) {
                    sb.append(".*");
                }
                suf = false;
                sb.append('|');
            }
            int f = 0;
            while (f < gl.length()) {
                char ch = gl.charAt(f);
                if (ch == '*') {
                    suf = true;
                    sb.append(gl.endsWith(".") ? "[^.]" : ".");
                } else if (ch == '?') {
                    ch = '.';
                    suf = true;
                } else if (ch == '.') {
                    suf = true;
                    if (f + 1 == gl.length()) break;
                    sb.append('\\');
                } else if (!Character.isLetterOrDigit(ch)) {
                    sb.append('\\');
                }
                sb.append(ch);
                ++f;
            }
            if (!suf && sub) {
                sb.append(".*");
            }
            ++n2;
        }
        return Prop.WIN ? sb.toString().toLowerCase() : sb.toString();
    }

    static class PathList
    extends StringList {
        PathList() {
        }

        String create(String path) {
            TokenBuilder tb = new TokenBuilder();
            int l = path.length();
            int i = 0;
            while (i < l) {
                char ch = path.charAt(i);
                if (ch == '\\' || ch == '/') {
                    this.add(tb);
                } else {
                    tb.add(ch);
                }
                ++i;
            }
            this.add(tb);
            int s = 0;
            while (s < this.size) {
                if (s != 0 || path.startsWith("/")) {
                    tb.add(47);
                }
                tb.add(this.list[s]);
                ++s;
            }
            return tb.toString();
        }

        private void add(TokenBuilder tb) {
            String s = tb.toString();
            if (s.length() > 1 && s.charAt(1) == ':' && this.size == 0) {
                s = String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
            }
            if (s.equals("..") && this.size > 0) {
                if (this.list[this.size - 1].indexOf(58) == -1) {
                    this.delete(this.size - 1);
                }
            } else if (!s.equals(".") && !s.isEmpty()) {
                this.add(s);
            }
            tb.reset();
        }
    }
}

