/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.util.list.ByteList;
import org.xml.sax.InputSource;

public final class IOUrl
extends IO {
    private static final Pattern DUPLSLASH = Pattern.compile("//+");
    private static final Pattern LEADSLASH = Pattern.compile("^/([A-Za-z]:)");

    public IOUrl(String u) {
        super(u);
    }

    @Override
    public byte[] read() throws IOException {
        ByteList bl = new ByteList();
        BufferedInputStream bis = new BufferedInputStream(new URL(this.path).openStream());
        try {
            int b;
            while ((b = bis.read()) != -1) {
                bl.add(b);
            }
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
        return bl.toArray();
    }

    @Override
    public InputSource inputSource() {
        return new InputSource(this.path);
    }

    @Override
    public BufferInput buffer() throws IOException {
        return new BufferInput(new URL(this.path).openStream());
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public IO merge(String f) {
        return this;
    }

    public static String file(String url) {
        String file = url;
        try {
            if (file.indexOf("%") != -1) {
                file = URLDecoder.decode(file, Prop.ENCODING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file.startsWith("file:")) {
            file = file.substring("file:".length());
        }
        if (file.contains("//")) {
            file = DUPLSLASH.matcher(file).replaceAll("/");
        }
        return LEADSLASH.matcher(file).replaceFirst("$1");
    }
}

