/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.basex.util.Util;

public final class MimeTypes {
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APP_OCTET = "application/octet-stream";
    public static final String APP_XML = "application/xml";
    public static final String APP_XQUERY = "application/xquery";
    public static final String APP_JSON = "application/json";
    private static final HashMap<String, String> TYPES;

    static {
        block15: {
            TYPES = new HashMap();
            BufferedReader br = null;
            try {
                try {
                    String file = "/mime.txt";
                    InputStream is = MimeTypes.class.getResourceAsStream("/mime.txt");
                    if (is == null) {
                        Util.errln("/mime.txt not found.", new Object[0]);
                    } else {
                        String line;
                        br = new BufferedReader(new InputStreamReader(is));
                        while ((line = br.readLine()) != null) {
                            int i = line.indexOf(9);
                            if (i == -1 || line.startsWith("#")) continue;
                            TYPES.put(line.substring(0, i), line.substring(i + 1));
                        }
                    }
                }
                catch (IOException ex) {
                    Util.errln(ex, new Object[0]);
                    if (br == null) break block15;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private MimeTypes() {
    }

    public static String get(String path) {
        String ct;
        int i = path.lastIndexOf(46);
        if (i != -1 && (ct = TYPES.get(path.substring(i + 1))) != null) {
            return ct;
        }
        return APP_OCTET;
    }
}

